/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.text.BarString;
import pro.fessional.wings.slardar.context.Now;

public interface WarlockTicketService {
    @Nullable
    public Term decode(String var1);

    @NotNull
    public String encode(@NotNull Term var1, @NotNull Duration var2);

    @Nullable
    public Pass findPass(@NotNull String var1);

    public int nextSeq(long var1, int var3);

    public void revokeAll(long var1);

    default public long calcDue(@NotNull Duration ttl) {
        return Now.millis() / 1000L + ttl.toSeconds();
    }

    default public boolean checkSeq(long uid, int type, int seq) {
        return seq >= 0;
    }

    public static class SimpleTerm
    implements Term {
        protected int type = 0;
        protected long userId = Long.MIN_VALUE;
        protected String scopes = "";
        protected String clientId = "";
        protected String sessionId = "";

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public long getUserId() {
            return this.userId;
        }

        @Override
        public String getScopes() {
            return this.scopes;
        }

        @Override
        public String getClientId() {
            return this.clientId;
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public void setType(int type) {
            this.type = type;
        }

        @Override
        public void setUserId(long userId) {
            this.userId = userId;
        }

        @Override
        public void setScopes(String scopes) {
            this.scopes = scopes;
        }

        @Override
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleTerm)) {
                return false;
            }
            SimpleTerm other = (SimpleTerm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.getUserId() != other.getUserId()) {
                return false;
            }
            String this$scopes = this.getScopes();
            String other$scopes = other.getScopes();
            if (this$scopes == null ? other$scopes != null : !this$scopes.equals(other$scopes)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$sessionId = this.getSessionId();
            String other$sessionId = other.getSessionId();
            return !(this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof SimpleTerm;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            long $userId = this.getUserId();
            result = result * 59 + (int)($userId >>> 32 ^ $userId);
            String $scopes = this.getScopes();
            result = result * 59 + ($scopes == null ? 43 : $scopes.hashCode());
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $sessionId = this.getSessionId();
            result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "WarlockTicketService.SimpleTerm(type=" + this.getType() + ", userId=" + this.getUserId() + ", scopes=" + this.getScopes() + ", clientId=" + this.getClientId() + ", sessionId=" + this.getSessionId() + ")";
        }
    }

    public static interface Term {
        public static final int TypeEmpty = 0;
        public static final int TypeAuthorizeCode = 1;
        public static final int TypeAccessToken = 2;

        default public boolean decode(String str) {
            return this.decode(str, true);
        }

        default public boolean decode(String str, boolean exactly) {
            int size = this.getSize();
            ArrayList parts = BarString.split((String)str, (int)size, (boolean)exactly);
            if (parts.size() < size) {
                return false;
            }
            Iterator it = parts.iterator();
            this.setType(Integer.parseInt((String)it.next()));
            this.setUserId(Long.parseLong((String)it.next()));
            this.setScopes((String)it.next());
            this.setClientId((String)it.next());
            this.setSessionId((String)it.next());
            return true;
        }

        public static String encode(Term term) {
            BarString buff = new BarString();
            buff.append(term.getType());
            buff.append(term.getUserId());
            buff.append((Object)term.getScopes());
            buff.append((Object)term.getClientId());
            buff.append((Object)term.getSessionId());
            return buff.toString();
        }

        default public int getSize() {
            return 5;
        }

        public int getType();

        public void setType(int var1);

        public long getUserId();

        public void setUserId(long var1);

        public String getScopes();

        public void setScopes(String var1);

        public String getClientId();

        public void setClientId(String var1);

        public String getSessionId();

        public void setSessionId(String var1);
    }

    public static class Pass {
        protected long userId = Long.MIN_VALUE;
        protected String client = "";
        protected String secret = "";
        protected Set<String> scopes = Collections.emptySet();
        protected Set<String> hosts = Collections.emptySet();

        public long getUserId() {
            return this.userId;
        }

        public String getClient() {
            return this.client;
        }

        public String getSecret() {
            return this.secret;
        }

        public Set<String> getScopes() {
            return this.scopes;
        }

        public Set<String> getHosts() {
            return this.hosts;
        }

        public void setUserId(long userId) {
            this.userId = userId;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public void setScopes(Set<String> scopes) {
            this.scopes = scopes;
        }

        public void setHosts(Set<String> hosts) {
            this.hosts = hosts;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pass)) {
                return false;
            }
            Pass other = (Pass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserId() != other.getUserId()) {
                return false;
            }
            String this$client = this.getClient();
            String other$client = other.getClient();
            if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
                return false;
            }
            Set<String> this$scopes = this.getScopes();
            Set<String> other$scopes = other.getScopes();
            if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
                return false;
            }
            Set<String> this$hosts = this.getHosts();
            Set<String> other$hosts = other.getHosts();
            return !(this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Pass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $userId = this.getUserId();
            result = result * 59 + (int)($userId >>> 32 ^ $userId);
            String $client = this.getClient();
            result = result * 59 + ($client == null ? 43 : $client.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            Set<String> $scopes = this.getScopes();
            result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
            Set<String> $hosts = this.getHosts();
            result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "WarlockTicketService.Pass(userId=" + this.getUserId() + ", client=" + this.getClient() + ", secret=" + this.getSecret() + ", scopes=" + String.valueOf(this.getScopes()) + ", hosts=" + String.valueOf(this.getHosts()) + ")";
        }
    }
}

