/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthToken;
import pro.fessional.wings.slardar.security.impl.AbstractAuthPermCheckCombo;

public class AuthZonePermChecker
extends AbstractAuthPermCheckCombo {
    private Map<String, Set<String>> zonePerm = Collections.emptyMap();

    protected Collection<String> requirePermit(WingsUserDetails userDetails, WingsBindAuthToken authentication) {
        Object details = authentication.getDetails();
        if (details instanceof WingsAuthDetails) {
            String authZone = (String)((WingsAuthDetails)details).getMetaData().get("authZone");
            if (authZone == null) {
                return Collections.emptySet();
            }
            return this.zonePerm.getOrDefault(authZone, Collections.emptySet());
        }
        return Collections.emptySet();
    }

    public int getOrder() {
        return 0;
    }

    public void setZonePerm(Map<String, Set<String>> zonePerm) {
        this.zonePerm = zonePerm;
    }

    public Map<String, Set<String>> getZonePerm() {
        return this.zonePerm;
    }
}

