/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import pro.fessional.wings.slardar.security.impl.DefaultWingsUserDetails;
import pro.fessional.wings.warlock.enums.autogen.GrantType;
import pro.fessional.wings.warlock.service.auth.WarlockAuthzService;
import pro.fessional.wings.warlock.service.grant.PermGrantHelper;
import pro.fessional.wings.warlock.service.grant.WarlockGrantService;
import pro.fessional.wings.warlock.service.perm.WarlockPermNormalizer;
import pro.fessional.wings.warlock.service.perm.WarlockPermService;
import pro.fessional.wings.warlock.service.perm.WarlockRoleService;

public class ComboWarlockAuthzService
implements WarlockAuthzService {
    private static final Logger log = LoggerFactory.getLogger(ComboWarlockAuthzService.class);
    protected WarlockPermNormalizer permNormalizer;
    protected WarlockRoleService warlockRoleService;
    protected WarlockPermService warlockPermService;
    protected WarlockGrantService warlockGrantService;
    private List<Combo> authCombos = Collections.emptyList();
    private boolean authorityRole = true;
    private boolean authorityPerm = true;

    @Override
    public void auth(DefaultWingsUserDetails details) {
        if (details == null) {
            return;
        }
        HashSet<Object> roleObjs = new HashSet<Object>();
        HashSet<Object> permObjs = new HashSet<Object>();
        for (Combo combo : this.authCombos) {
            if (!combo.preAuth(details, roleObjs, permObjs)) continue;
            log.debug("break authCombos.preAuth, combo={}", combo.getClass());
            break;
        }
        HashMap<String, GrantedAuthority> auths = new HashMap<String, GrantedAuthority>();
        Collection olds = details.getAuthorities();
        if (olds != null) {
            for (GrantedAuthority old : olds) {
                auths.put(old.getAuthority(), old);
            }
        }
        HashSet<Long> roleIds = new HashSet<Long>();
        if (this.authorityRole) {
            this.buildGrantRoles(roleObjs, auths, roleIds);
        } else {
            log.debug("skip authorityRole");
        }
        if (this.authorityPerm) {
            this.buildGrantPerms(permObjs, auths, roleIds);
        } else {
            log.debug("skip authorityPerm");
        }
        for (Combo combo : this.authCombos) {
            combo.postAuth(details, auths);
        }
        details.setAuthorities(new HashSet<GrantedAuthority>(auths.values()));
    }

    protected void buildGrantRoles(Set<Object> roleObjs, HashMap<String, GrantedAuthority> auth, Set<Long> roleIds) {
        HashSet<String> roleStr = new HashSet<String>();
        HashSet<String> denyStr = new HashSet<String>();
        for (Object ro : roleObjs) {
            if (ro instanceof Long) {
                log.debug("add role by id={}", ro);
                roleIds.add((Long)ro);
                continue;
            }
            if (ro instanceof String) {
                String string = this.permNormalizer.role((String)ro);
                int off = this.permNormalizer.indexDenyPrefix(string);
                if (off > 0) {
                    log.debug("off role by str={}", ro);
                    denyStr.add(string.substring(off));
                    continue;
                }
                log.debug("add role by str={}", ro);
                roleStr.add(string);
                auth.putIfAbsent(string, (GrantedAuthority)new SimpleGrantedAuthority(string));
                continue;
            }
            if (ro instanceof GrantedAuthority) {
                GrantedAuthority gt = (GrantedAuthority)ro;
                String string = this.permNormalizer.role(gt.getAuthority());
                log.debug("add role by aut={}", (Object)string);
                auth.put(string, gt);
                roleStr.add(string);
                continue;
            }
            throw new IllegalStateException("unsupported type=" + String.valueOf(ro.getClass()) + ", value=" + String.valueOf(ro));
        }
        Map<Long, String> allRoles = this.warlockRoleService.loadRoleAll();
        HashSet<Long> excIds = new HashSet<Long>();
        for (Map.Entry entry : allRoles.entrySet()) {
            String str = (String)entry.getValue();
            if (denyStr.contains(str)) {
                excIds.add((Long)entry.getKey());
                continue;
            }
            if (!roleStr.contains(str)) continue;
            roleIds.add((Long)entry.getKey());
        }
        auth.keySet().removeAll(denyStr);
        Set<Long> sub = new HashSet<Long>(roleIds);
        while (true) {
            sub = this.warlockGrantService.entryRole(GrantType.ROLE, sub).keySet();
            int n = roleIds.size();
            roleIds.addAll(sub);
            if (n == roleIds.size()) break;
            roleIds.removeAll(excIds);
        }
        roleIds.removeAll(excIds);
        for (Long rid : roleIds) {
            String s = allRoles.get(rid);
            if (s == null || denyStr.contains(s)) continue;
            auth.putIfAbsent(s, (GrantedAuthority)new SimpleGrantedAuthority(s));
        }
    }

    protected void buildGrantPerms(Set<Object> permObjs, HashMap<String, GrantedAuthority> auth, Set<Long> roleIds) {
        Map<Long, String> permAll = this.warlockPermService.loadPermAll();
        HashSet<String> permStr = new HashSet<String>();
        HashSet<String> denyStr = new HashSet<String>();
        for (Object po : permObjs) {
            if (po instanceof Long) {
                String s = permAll.get(po);
                if (s == null) continue;
                permStr.add(s);
                continue;
            }
            if (po instanceof String) {
                String pm = (String)po;
                int off = this.permNormalizer.indexDenyPrefix(pm);
                if (off < 0) {
                    permStr.add(pm);
                    auth.put(pm, (GrantedAuthority)new SimpleGrantedAuthority(pm));
                    continue;
                }
                denyStr.add(pm.substring(off));
                continue;
            }
            if (po instanceof GrantedAuthority) {
                GrantedAuthority gt = (GrantedAuthority)po;
                String au = gt.getAuthority();
                auth.put(au, gt);
                permStr.add(au);
                continue;
            }
            throw new IllegalStateException("unsupported type=" + String.valueOf(po.getClass()) + ", value=" + String.valueOf(po));
        }
        permStr.removeAll(denyStr);
        Set permIds = this.warlockGrantService.entryRole(GrantType.PERM, roleIds).keySet();
        for (Long pid : permIds) {
            String s = permAll.get(pid);
            if (s == null || denyStr.contains(s)) continue;
            permStr.add(s);
        }
        for (String str : permStr) {
            Set ps = PermGrantHelper.inheritPerm((String)str, permAll);
            for (String s : ps) {
                if (s.contains("*") || denyStr.contains(s)) continue;
                auth.putIfAbsent(s, (GrantedAuthority)new SimpleGrantedAuthority(s));
            }
        }
        auth.keySet().removeAll(denyStr);
    }

    @Autowired
    public void setPermNormalizer(WarlockPermNormalizer permNormalizer) {
        this.permNormalizer = permNormalizer;
    }

    @Autowired
    public void setWarlockRoleService(WarlockRoleService warlockRoleService) {
        this.warlockRoleService = warlockRoleService;
    }

    @Autowired
    public void setWarlockPermService(WarlockPermService warlockPermService) {
        this.warlockPermService = warlockPermService;
    }

    @Autowired
    public void setWarlockGrantService(WarlockGrantService warlockGrantService) {
        this.warlockGrantService = warlockGrantService;
    }

    @Autowired(required=false)
    public void setAuthCombos(List<Combo> authCombos) {
        this.authCombos = authCombos;
    }

    public void setAuthorityRole(boolean authorityRole) {
        this.authorityRole = authorityRole;
    }

    public boolean isAuthorityRole() {
        return this.authorityRole;
    }

    public void setAuthorityPerm(boolean authorityPerm) {
        this.authorityPerm = authorityPerm;
    }

    public boolean isAuthorityPerm() {
        return this.authorityPerm;
    }

    public static interface Combo
    extends Ordered {
        public boolean preAuth(@NotNull DefaultWingsUserDetails var1, @NotNull HashSet<Object> var2, @NotNull HashSet<Object> var3);

        default public void postAuth(@NotNull DefaultWingsUserDetails details, @NotNull HashMap<String, GrantedAuthority> auths) {
        }
    }
}

