/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.wings.slardar.event.EventPublishHelper;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.impl.ComboWingsUserDetailsService;
import pro.fessional.wings.slardar.security.impl.DefaultWingsUserDetails;
import pro.fessional.wings.warlock.event.auth.WarlockAutoRegisterEvent;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;
import pro.fessional.wings.warlock.service.auth.WarlockAuthzService;

public class DefaultUserDetailsCombo
implements ComboWingsUserDetailsService.Combo<DefaultWingsUserDetails> {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserDetailsCombo.class);
    public static final int ORDER = -49999100;
    private int order = -49999100;
    private Set<Enum<?>> autoRegisterType = new HashSet();
    protected WarlockAuthnService warlockAuthnService;
    protected WarlockAuthzService warlockAuthzService;

    public final DefaultWingsUserDetails loadOrNull(String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
        WarlockAuthnService.Details dt = this.doLoad(username, authType, authDetail);
        boolean at = false;
        if (dt == null && this.canRegister(username, authType, authDetail) && (dt = this.doRegister(username, authType, authDetail)) != null) {
            at = true;
            EventPublishHelper.SyncSpring.publishEvent((Object)new WarlockAutoRegisterEvent(dt));
        }
        if (dt == null) {
            return null;
        }
        if (at) {
            log.debug("autoreg auth-user, username={}, auth-type={}, class={}", new Object[]{username, authType, this.getClass()});
        } else {
            log.debug("loading auth-user, username={}, auth-type={}, class={}", new Object[]{username, authType, this.getClass()});
        }
        DefaultWingsUserDetails wud = this.newUserDetails(dt);
        this.warlockAuthnService.auth(wud, dt);
        this.warlockAuthzService.auth(wud);
        if (!wud.isPreAuthed()) {
            wud.setPreAuthed(at || this.asAuthed(wud));
        }
        return wud;
    }

    protected DefaultWingsUserDetails newUserDetails(@NotNull WarlockAuthnService.Details dt) {
        return new DefaultWingsUserDetails();
    }

    protected WarlockAuthnService.Details doRegister(String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
        return this.warlockAuthnService.register(authType, username, authDetail);
    }

    protected boolean canRegister(String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
        return this.autoRegisterType.contains(authType);
    }

    public boolean asAuthed(@NotNull DefaultWingsUserDetails details) {
        return false;
    }

    @Nullable
    public WarlockAuthnService.Details doLoad(String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
        return this.warlockAuthnService.load(authType, username);
    }

    public int getOrder() {
        return this.order;
    }

    public Set<Enum<?>> getAutoRegisterType() {
        return this.autoRegisterType;
    }

    public WarlockAuthnService getWarlockAuthnService() {
        return this.warlockAuthnService;
    }

    public WarlockAuthzService getWarlockAuthzService() {
        return this.warlockAuthzService;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setAutoRegisterType(Set<Enum<?>> autoRegisterType) {
        this.autoRegisterType = autoRegisterType;
    }

    @Autowired
    public void setWarlockAuthnService(WarlockAuthnService warlockAuthnService) {
        this.warlockAuthnService = warlockAuthnService;
    }

    @Autowired
    public void setWarlockAuthzService(WarlockAuthzService warlockAuthzService) {
        this.warlockAuthzService = warlockAuthzService;
    }
}

