/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.tk.Ticket;
import pro.fessional.mirana.tk.TicketHelp;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.warlock.service.auth.WarlockTicketService;

public class SimpleTicketServiceImpl
implements WarlockTicketService {
    private final ConcurrentHashMap<Long, AtomicInteger> accessTokenSeq = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, AtomicInteger> authorizeCodeSeq = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, WarlockTicketService.Pass> client = new ConcurrentHashMap();
    private volatile int authorizeCodeMax = 3;
    private volatile int accessTokenMax = 5;
    protected TicketHelp.Helper<String> helper;

    public void addClient(@NotNull WarlockTicketService.Pass pass) {
        this.client.put(pass.getClient(), pass);
    }

    @Override
    public WarlockTicketService.Term decode(String token) {
        BiFunction[] biFunctionArray = new BiFunction[1];
        biFunctionArray[0] = (arg_0, arg_1) -> this.helper.accept(arg_0, arg_1);
        Ticket tk = TicketHelp.parse((String)token, (BiFunction[])biFunctionArray);
        if (tk == null || tk.getPubDue() * 1000L < Now.millis()) {
            return null;
        }
        WarlockTicketService.SimpleTerm term = new WarlockTicketService.SimpleTerm();
        boolean ok = term.decode((String)this.helper.decode(tk));
        if (ok) {
            ok = this.checkSeq(term.getUserId(), term.getType(), tk.getPubSeq());
        }
        return ok ? term : null;
    }

    @Override
    @NotNull
    public String encode(@NotNull WarlockTicketService.Term term, @NotNull Duration ttl) {
        int seq = this.nextSeq(term.getUserId(), term.getType());
        long due = this.calcDue(ttl);
        Ticket ticket = this.helper.encode(seq, due, (Object)WarlockTicketService.Term.encode(term));
        return ticket.serialize();
    }

    @Override
    @Nullable
    public WarlockTicketService.Pass findPass(@NotNull String clientId) {
        return this.client.get(clientId);
    }

    @Override
    public int nextSeq(long uid, int type) {
        AtomicInteger cnt = this.getSeqMap(type).computeIfAbsent(uid, k -> new AtomicInteger(0));
        return cnt.incrementAndGet();
    }

    @Override
    public boolean checkSeq(long uid, int type, int seq) {
        if (seq < 0) {
            return false;
        }
        int cur = this.getSeqMap(type).computeIfAbsent(uid, k -> new AtomicInteger(seq)).get();
        return cur - seq <= this.accessTokenMax;
    }

    @NotNull
    private ConcurrentHashMap<Long, AtomicInteger> getSeqMap(int type) {
        if (type == 1) {
            return this.authorizeCodeSeq;
        }
        if (type == 2) {
            return this.accessTokenSeq;
        }
        throw new IllegalArgumentException("unsupported type=" + type);
    }

    @Override
    public void revokeAll(long uid) {
        AtomicInteger cs;
        int step = this.accessTokenMax * 10;
        AtomicInteger ts = this.accessTokenSeq.get(uid);
        if (ts != null) {
            ts.addAndGet(step);
        }
        if ((cs = this.authorizeCodeSeq.get(uid)) != null) {
            cs.addAndGet(step);
        }
    }

    public ConcurrentHashMap<String, WarlockTicketService.Pass> getClient() {
        return this.client;
    }

    public void setAuthorizeCodeMax(int authorizeCodeMax) {
        this.authorizeCodeMax = authorizeCodeMax;
    }

    public int getAuthorizeCodeMax() {
        return this.authorizeCodeMax;
    }

    public void setAccessTokenMax(int accessTokenMax) {
        this.accessTokenMax = accessTokenMax;
    }

    public int getAccessTokenMax() {
        return this.accessTokenMax;
    }

    public void setHelper(TicketHelp.Helper<String> helper) {
        this.helper = helper;
    }

    public TicketHelp.Helper<String> getHelper() {
        return this.helper;
    }
}

