/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.wings.warlock.security.SafeHttpHelper;
import pro.fessional.wings.warlock.service.auth.WarlockOauthService;
import pro.fessional.wings.warlock.service.auth.WarlockTicketService;

public class WarlockOauthServiceImpl
implements WarlockOauthService {
    protected Duration authCodeTtl;
    protected Duration accessTokenTtl;
    protected WarlockTicketService warlockTicketService;
    private final Pattern scopeSplitter = Pattern.compile("[ ,;]+");

    @Override
    @NotNull
    public WarlockOauthService.OAuth authorizeCode(@NotNull String clientId, String scope, String redirectUri, String session) {
        WarlockOauthService.OAuth data = new WarlockOauthService.OAuth();
        WarlockTicketService.Pass pass = this.warlockTicketService.findPass(clientId);
        if (pass == null) {
            data.put("error", "unauthorized_client");
            data.put("error_description", "the client is not allowed to request an authorization code");
            return data;
        }
        if (!this.checkScope(pass.getScopes(), scope)) {
            data.put("error", "invalid_scope");
            data.put("error_description", "the requested scope is invalid or unknown");
            return data;
        }
        if (!this.checkRedirect(pass.getHosts(), redirectUri)) {
            data.put("error", "invalid_redirect");
            data.put("error_description", "the redirect_uri is invalid");
            return data;
        }
        WarlockTicketService.SimpleTerm term = new WarlockTicketService.SimpleTerm();
        term.setType(1);
        term.setUserId(pass.getUserId());
        term.setScopes(scope);
        term.setClientId(clientId);
        if (session != null) {
            term.setSessionId(session);
        }
        String ticket = this.warlockTicketService.encode(term, this.authCodeTtl);
        data.put("code", ticket);
        data.put("expires_in", this.authCodeTtl.toSeconds());
        return data;
    }

    protected boolean checkScope(Set<String> scopes, String scope) {
        if (scopes.isEmpty()) {
            return true;
        }
        if (scope == null) {
            return false;
        }
        for (String s : this.scopeSplitter.split(scope)) {
            if (scopes.contains(s)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkRedirect(Set<String> hosts, String uri) {
        if (uri == null || uri.isEmpty()) {
            return true;
        }
        return SafeHttpHelper.isSafeRedirect(uri, hosts);
    }

    @Override
    @NotNull
    public WarlockOauthService.OAuth accessToken(@NotNull String clientId, @NotNull String clientSecret, String token) {
        boolean clientCredentials;
        WarlockTicketService.Pass pass;
        WarlockTicketService.Term term;
        WarlockOauthService.OAuth data = new WarlockOauthService.OAuth();
        if (token == null || token.isEmpty()) {
            term = new WarlockTicketService.SimpleTerm();
            pass = this.warlockTicketService.findPass(clientId);
            clientCredentials = true;
        } else {
            term = this.warlockTicketService.decode(token);
            if (term == null) {
                data.put("error", "invalid_request");
                data.put("error_description", "invalid ticket");
                return data;
            }
            pass = this.warlockTicketService.findPass(clientId);
            clientCredentials = false;
        }
        if (pass == null || !Objects.equals(clientSecret, pass.getSecret()) || !Objects.equals(clientId, pass.getClient())) {
            data.put("error", "invalid_client");
            data.put("error_description", "Client authentication failed");
            return data;
        }
        term.setType(2);
        if (clientCredentials) {
            term.setUserId(pass.getUserId());
            term.setClientId(pass.getClient());
            term.setScopes(String.join((CharSequence)" ", pass.getScopes()));
        }
        String ticket = this.warlockTicketService.encode(term, this.accessTokenTtl);
        data.put("access_token", ticket);
        data.put("expires_in", this.accessTokenTtl.toSeconds());
        data.put("scope", term.getScopes());
        return data;
    }

    @Override
    @NotNull
    public WarlockOauthService.OAuth revokeToken(@NotNull String clientId, @NotNull String token) {
        WarlockOauthService.OAuth data = new WarlockOauthService.OAuth();
        WarlockTicketService.Term term = this.warlockTicketService.decode(token);
        if (term == null || !Objects.equals(clientId, term.getClientId())) {
            data.put("error", "invalid_request");
            data.put("error_description", "invalid ticket");
        } else {
            this.warlockTicketService.revokeAll(term.getUserId());
            data.put("access_token", "");
            data.put("expires_in", 0);
            data.put("scope", term.getScopes());
        }
        return data;
    }

    public void setAuthCodeTtl(Duration authCodeTtl) {
        this.authCodeTtl = authCodeTtl;
    }

    public void setAccessTokenTtl(Duration accessTokenTtl) {
        this.accessTokenTtl = accessTokenTtl;
    }

    public Duration getAuthCodeTtl() {
        return this.authCodeTtl;
    }

    public Duration getAccessTokenTtl() {
        return this.accessTokenTtl;
    }

    public WarlockTicketService getWarlockTicketService() {
        return this.warlockTicketService;
    }

    public Pattern getScopeSplitter() {
        return this.scopeSplitter;
    }

    @Autowired
    public void setWarlockTicketService(WarlockTicketService warlockTicketService) {
        this.warlockTicketService = warlockTicketService;
    }
}

