/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.user;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.wings.faceless.convention.EmptyValue;
import pro.fessional.wings.slardar.context.Now;

public interface WarlockUserAuthnService {
    public long create(long var1, @NotNull Authn var3);

    public void modify(long var1, @NotNull Authn var3);

    public void renew(long var1, @NotNull Renew var3);

    public void dander(long var1, boolean var3, Enum<?> ... var4);

    default public void disable(long userId, @NotNull Enum<?> authType) {
        Renew renew = new Renew();
        renew.setAuthType(authType);
        renew.setExpiredDt(EmptyValue.DATE_TIME);
        this.renew(userId, renew);
    }

    default public void enable(long userId, @NotNull Enum<?> authType, Duration expireIn) {
        Renew renew = new Renew();
        renew.setAuthType(authType);
        renew.setExpiredDt(Now.localDateTime().plusSeconds(expireIn.getSeconds()));
        this.renew(userId, renew);
    }

    @NotNull
    public List<Item> list(long var1);

    public static class Renew {
        private Enum<?> authType;
        private String password;
        private LocalDateTime expiredDt;
        private Integer failedCnt;
        private Integer failedMax;

        public Enum<?> getAuthType() {
            return this.authType;
        }

        public String getPassword() {
            return this.password;
        }

        public LocalDateTime getExpiredDt() {
            return this.expiredDt;
        }

        public Integer getFailedCnt() {
            return this.failedCnt;
        }

        public Integer getFailedMax() {
            return this.failedMax;
        }

        public void setAuthType(Enum<?> authType) {
            this.authType = authType;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setExpiredDt(LocalDateTime expiredDt) {
            this.expiredDt = expiredDt;
        }

        public void setFailedCnt(Integer failedCnt) {
            this.failedCnt = failedCnt;
        }

        public void setFailedMax(Integer failedMax) {
            this.failedMax = failedMax;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Renew)) {
                return false;
            }
            Renew other = (Renew)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$failedCnt = this.getFailedCnt();
            Integer other$failedCnt = other.getFailedCnt();
            if (this$failedCnt == null ? other$failedCnt != null : !((Object)this$failedCnt).equals(other$failedCnt)) {
                return false;
            }
            Integer this$failedMax = this.getFailedMax();
            Integer other$failedMax = other.getFailedMax();
            if (this$failedMax == null ? other$failedMax != null : !((Object)this$failedMax).equals(other$failedMax)) {
                return false;
            }
            Enum<?> this$authType = this.getAuthType();
            Enum<?> other$authType = other.getAuthType();
            if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            LocalDateTime this$expiredDt = this.getExpiredDt();
            LocalDateTime other$expiredDt = other.getExpiredDt();
            return !(this$expiredDt == null ? other$expiredDt != null : !((Object)this$expiredDt).equals(other$expiredDt));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Renew;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $failedCnt = this.getFailedCnt();
            result = result * 59 + ($failedCnt == null ? 43 : ((Object)$failedCnt).hashCode());
            Integer $failedMax = this.getFailedMax();
            result = result * 59 + ($failedMax == null ? 43 : ((Object)$failedMax).hashCode());
            Enum<?> $authType = this.getAuthType();
            result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            LocalDateTime $expiredDt = this.getExpiredDt();
            result = result * 59 + ($expiredDt == null ? 43 : ((Object)$expiredDt).hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "WarlockUserAuthnService.Renew(authType=" + String.valueOf(this.getAuthType()) + ", password=" + this.getPassword() + ", expiredDt=" + String.valueOf(this.getExpiredDt()) + ", failedCnt=" + this.getFailedCnt() + ", failedMax=" + this.getFailedMax() + ")";
        }
    }

    public static class Item {
        private String username;
        private String authType;
        private LocalDateTime expiredDt;
        private int failedCnt;

        public String getUsername() {
            return this.username;
        }

        public String getAuthType() {
            return this.authType;
        }

        public LocalDateTime getExpiredDt() {
            return this.expiredDt;
        }

        public int getFailedCnt() {
            return this.failedCnt;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setAuthType(String authType) {
            this.authType = authType;
        }

        public void setExpiredDt(LocalDateTime expiredDt) {
            this.expiredDt = expiredDt;
        }

        public void setFailedCnt(int failedCnt) {
            this.failedCnt = failedCnt;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFailedCnt() != other.getFailedCnt()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$authType = this.getAuthType();
            String other$authType = other.getAuthType();
            if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
                return false;
            }
            LocalDateTime this$expiredDt = this.getExpiredDt();
            LocalDateTime other$expiredDt = other.getExpiredDt();
            return !(this$expiredDt == null ? other$expiredDt != null : !((Object)this$expiredDt).equals(other$expiredDt));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFailedCnt();
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $authType = this.getAuthType();
            result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
            LocalDateTime $expiredDt = this.getExpiredDt();
            result = result * 59 + ($expiredDt == null ? 43 : ((Object)$expiredDt).hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "WarlockUserAuthnService.Item(username=" + this.getUsername() + ", authType=" + this.getAuthType() + ", expiredDt=" + String.valueOf(this.getExpiredDt()) + ", failedCnt=" + this.getFailedCnt() + ")";
        }
    }

    public static class Authn
    extends Renew {
        private String username;
        private String extraPara;
        private String extraUser;

        public String getUsername() {
            return this.username;
        }

        public String getExtraPara() {
            return this.extraPara;
        }

        public String getExtraUser() {
            return this.extraUser;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setExtraPara(String extraPara) {
            this.extraPara = extraPara;
        }

        public void setExtraUser(String extraUser) {
            this.extraUser = extraUser;
        }

        @Override
        @NotNull
        public String toString() {
            return "WarlockUserAuthnService.Authn(username=" + this.getUsername() + ", extraPara=" + this.getExtraPara() + ", extraUser=" + this.getExtraUser() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Authn)) {
                return false;
            }
            Authn other = (Authn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$extraPara = this.getExtraPara();
            String other$extraPara = other.getExtraPara();
            if (this$extraPara == null ? other$extraPara != null : !this$extraPara.equals(other$extraPara)) {
                return false;
            }
            String this$extraUser = this.getExtraUser();
            String other$extraUser = other.getExtraUser();
            return !(this$extraUser == null ? other$extraUser != null : !this$extraUser.equals(other$extraUser));
        }

        @Override
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Authn;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $extraPara = this.getExtraPara();
            result = result * 59 + ($extraPara == null ? 43 : $extraPara.hashCode());
            String $extraUser = this.getExtraUser();
            result = result * 59 + ($extraUser == null ? 43 : $extraUser.hashCode());
            return result;
        }
    }

    public static enum Jane {
        Create,
        Modify,
        Renew,
        Danger;

    }
}

