/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import com.xkcoding.http.config.HttpConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import me.zhyd.oauth.config.AuthConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.flow.FlowEnum;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;
import pro.fessional.wings.warlock.security.justauth.AuthConfigWrapper;
import pro.fessional.wings.warlock.security.justauth.AuthStateBuilder;
import pro.fessional.wings.warlock.security.justauth.JustAuthRequestBuilder;
import pro.fessional.wings.warlock.security.justauth.JustAuthStateCache;
import pro.fessional.wings.warlock.spring.prop.WarlockJustAuthProp;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class WarlockJustAuthConfiguration {
    private static final Log log = LogFactory.getLog(WarlockJustAuthConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public JustAuthStateCache authStateCache(WarlockJustAuthProp justAuthProp) {
        log.info((Object)"WarlockShadow spring-bean authStateCache");
        return new JustAuthStateCache(justAuthProp.getCacheSize(), justAuthProp.getCacheLive());
    }

    @Bean
    @ConditionalWingsEnabled
    public JustAuthRequestBuilder.SuccessHandler justAuthRequestSuccessHandler(AuthStateBuilder authStateBuilder, WingsRemoteResolver remoteResolver) {
        log.info((Object)"WarlockShadow spring-bean justAuthRequestSuccessHandler");
        return (authType, request, authUser, detail) -> {
            Map meta = detail.getMetaData();
            meta.put("authType", authType.name());
            meta.put("authZone", authStateBuilder.parseAuthZone(request));
            meta.put("AuthAddr", remoteResolver.resolveRemoteIp(request));
            meta.put("AuthAgent", remoteResolver.resolveAgentInfo(request));
            return FlowEnum.Default;
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public JustAuthRequestBuilder justAuthRequestBuilder(WarlockJustAuthProp justAuthProp, WarlockSecurityProp securityProp) {
        log.info((Object)"WarlockShadow spring-bean justAuthRequestFactory");
        JustAuthRequestBuilder bean = new JustAuthRequestBuilder();
        Map<String, WarlockJustAuthProp.Http> hcs = justAuthProp.getHttpConf();
        Map<String, Enum<?>> emp = securityProp.mapAuthTypeEnum();
        HashMap map = new HashMap();
        for (Map.Entry<String, AuthConfig> en : justAuthProp.getAuthType().entrySet()) {
            String k = en.getKey();
            Enum<?> em = emp.get(k);
            if (em == null) {
                throw new IllegalArgumentException("failed to map auth-type" + k);
            }
            AuthConfig ac = en.getValue();
            WarlockJustAuthProp.Http hc = hcs.get(k);
            if (hc == null || !StringUtils.hasText((String)hc.getProxyHost()) || Proxy.Type.DIRECT.name().equalsIgnoreCase(hc.getProxyType())) {
                log.info((Object)("WarlockShadow conf justAuthRequestFactory auth-type " + k));
            } else {
                Proxy.Type ht = Proxy.Type.valueOf(hc.getProxyType());
                Proxy proxy = new Proxy(ht, new InetSocketAddress(hc.getProxyHost(), hc.getProxyPort()));
                ac.setHttpConfig(HttpConfig.builder().timeout(hc.getTimeout() * 1000).proxy(proxy).build());
                log.info((Object)("WarlockShadow conf justAuthRequestFactory auth-type " + k + ", proxy=" + hc.getProxyType()));
            }
            map.put(em, AuthConfigWrapper.tryWrap(ac, justAuthProp.getSafeHost()));
        }
        bean.setAuthConfigMap(map);
        return bean;
    }
}

