/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.slardar.errcode.AuthzErrorEnum;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;

public class AccessFailureHandler
implements AccessDeniedHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessFailureHandler.class);
    protected ObjectMapper objectMapper;
    protected MessageSource messageSource;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        log.debug("handled accessDeniedException", (Throwable)accessDeniedException);
        response.setStatus(HttpStatus.FORBIDDEN.value());
        response.setContentType("application/json");
        String code = AuthzErrorEnum.AccessDenied.getCode();
        String msg = this.messageSource.getMessage(code, (Object[])Null.StrArr, LocaleContextHolder.getLocale());
        String body = this.objectMapper.writeValueAsString((Object)R.ng((String)msg, (String)code));
        ResponseHelper.writeBodyUtf8((HttpServletResponse)response, (String)body);
    }

    @Autowired
    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Autowired
    @Generated
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

