/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.justauth;

import com.xkcoding.http.config.HttpConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import me.zhyd.oauth.config.AuthConfig;
import pro.fessional.mirana.text.StringTemplate;

public class AuthConfigWrapper
extends AuthConfig {
    public static final String RedirectUriHost = "{host}";
    public static final String RedirectUriScheme = "{scheme}";
    public static final String RedirectUriAuthType = "{authType}";
    public static final String RedirectUriAuthZone = "{authZone}";
    private final AuthConfig config;
    private final HttpServletRequest request;
    private final Set<String> safeHost;

    public static AuthConfig tryWrap(AuthConfig config, Set<String> safeHost) {
        String uri = config.getRedirectUri();
        if (uri != null && (uri.contains(RedirectUriHost) || uri.contains(RedirectUriScheme) || uri.contains(RedirectUriAuthType) || uri.contains(RedirectUriAuthZone))) {
            return new AuthConfigWrapper(config, safeHost, null);
        }
        return config;
    }

    public AuthConfigWrapper(AuthConfig config, Set<String> safeHost, HttpServletRequest request) {
        this.config = config;
        this.request = request;
        this.safeHost = safeHost;
    }

    public AuthConfig wrap(HttpServletRequest request) {
        return new AuthConfigWrapper(this.config, this.safeHost, request);
    }

    public String getRedirectUri() {
        String key;
        String uri = this.config.getRedirectUri();
        if (this.request == null) {
            return uri;
        }
        String host = this.request.getHeader("Host");
        if (this.safeHost != null && (key = this.request.getParameter("host")) != null && this.safeHost.contains(key)) {
            host = key;
        }
        return StringTemplate.dyn((String)uri).bindStr(RedirectUriHost, (Object)host).bindStr(RedirectUriScheme, (Object)this.request.getScheme()).bindStr(RedirectUriAuthType, (Object)this.request.getParameter("authType")).bindStr(RedirectUriAuthZone, (Object)this.request.getParameter("authZone")).toString();
    }

    @Generated
    public String getAuthServerId() {
        return this.config.getAuthServerId();
    }

    @Generated
    public String getClientId() {
        return this.config.getClientId();
    }

    @Generated
    public String getClientSecret() {
        return this.config.getClientSecret();
    }

    @Deprecated
    @Generated
    public String getAlipayPublicKey() {
        return this.config.getAlipayPublicKey();
    }

    @Generated
    public boolean isUnionId() {
        return this.config.isUnionId();
    }

    @Generated
    public String getStackOverflowKey() {
        return this.config.getStackOverflowKey();
    }

    @Generated
    public String getAgentId() {
        return this.config.getAgentId();
    }

    @Generated
    public String getUsertype() {
        return this.config.getUsertype();
    }

    @Generated
    public String getDomainPrefix() {
        return this.config.getDomainPrefix();
    }

    @Generated
    public HttpConfig getHttpConfig() {
        return this.config.getHttpConfig();
    }

    @Generated
    public boolean isIgnoreCheckState() {
        return this.config.isIgnoreCheckState();
    }

    @Generated
    public List<String> getScopes() {
        return this.config.getScopes();
    }

    @Generated
    public String getDeviceId() {
        return this.config.getDeviceId();
    }

    @Generated
    public Integer getClientOsType() {
        return this.config.getClientOsType();
    }

    @Generated
    public String getPackId() {
        return this.config.getPackId();
    }

    @Generated
    public boolean isPkce() {
        return this.config.isPkce();
    }

    @Generated
    public boolean isIgnoreCheckRedirectUri() {
        return this.config.isIgnoreCheckRedirectUri();
    }

    @Generated
    public String getTenantId() {
        return this.config.getTenantId();
    }

    @Generated
    public void setClientId(String clientId) {
        this.config.setClientId(clientId);
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.config.setClientSecret(clientSecret);
    }

    @Generated
    public void setRedirectUri(String redirectUri) {
        this.config.setRedirectUri(redirectUri);
    }

    @Deprecated
    @Generated
    public void setAlipayPublicKey(String alipayPublicKey) {
        this.config.setAlipayPublicKey(alipayPublicKey);
    }

    @Generated
    public void setUnionId(boolean unionId) {
        this.config.setUnionId(unionId);
    }

    @Generated
    public void setStackOverflowKey(String stackOverflowKey) {
        this.config.setStackOverflowKey(stackOverflowKey);
    }

    @Generated
    public void setAgentId(String agentId) {
        this.config.setAgentId(agentId);
    }

    @Generated
    public void setUsertype(String usertype) {
        this.config.setUsertype(usertype);
    }

    @Generated
    public void setDomainPrefix(String domainPrefix) {
        this.config.setDomainPrefix(domainPrefix);
    }

    @Generated
    public void setHttpConfig(HttpConfig httpConfig) {
        this.config.setHttpConfig(httpConfig);
    }

    @Generated
    public void setIgnoreCheckState(boolean ignoreCheckState) {
        this.config.setIgnoreCheckState(ignoreCheckState);
    }

    @Generated
    public void setScopes(List<String> scopes) {
        this.config.setScopes(scopes);
    }

    @Generated
    public void setDeviceId(String deviceId) {
        this.config.setDeviceId(deviceId);
    }

    @Generated
    public void setClientOsType(Integer clientOsType) {
        this.config.setClientOsType(clientOsType);
    }

    @Generated
    public void setPackId(String packId) {
        this.config.setPackId(packId);
    }

    @Generated
    public void setPkce(boolean pkce) {
        this.config.setPkce(pkce);
    }

    @Generated
    public void setAuthServerId(String authServerId) {
        this.config.setAuthServerId(authServerId);
    }

    @Generated
    public void setIgnoreCheckRedirectUri(boolean ignoreCheckRedirectUri) {
        this.config.setIgnoreCheckRedirectUri(ignoreCheckRedirectUri);
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.config.setTenantId(tenantId);
    }

    private static interface DelegateExclude {
        public String getRedirectUri();
    }
}

