/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import pro.fessional.mirana.best.TypedReg;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.slardar.context.AttributeHolder;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.warlock.constants.WarlockGlobalAttribute;
import pro.fessional.wings.warlock.enums.autogen.UserGender;
import pro.fessional.wings.warlock.enums.autogen.UserStatus;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;
import pro.fessional.wings.warlock.service.auth.impl.ComboWarlockAuthnService;
import pro.fessional.wings.warlock.service.user.WarlockUserAuthnService;
import pro.fessional.wings.warlock.service.user.WarlockUserBasisService;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

public class DefaultUserAuthnAutoReg
implements ComboWarlockAuthnService.AutoReg {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAuthnAutoReg.class);
    public static final int ORDER = -49999990;
    private int order = -49999990;
    protected WarlockUserBasisService warlockUserBasisService;
    protected WarlockUserAuthnService warlockUserAuthnService;
    protected WarlockSecurityProp warlockSecurityProp;
    protected JournalService journalService;

    @Override
    @Transactional
    public WarlockAuthnService.Details create(@NotNull Enum<?> authType, String username, WingsAuthDetails details) {
        String mrk = "auto create auth-user auth-type=" + String.valueOf(authType) + "username=" + username;
        return (WarlockAuthnService.Details)this.journalService.submit((Enum)WarlockAuthnService.Jane.AutoSave, (Object)username, (Object)mrk, commit -> {
            WarlockUserBasisService.Basis user = new WarlockUserBasisService.Basis();
            user.setNickname(username);
            user.setAvatar("");
            user.setGender(UserGender.UNKNOWN);
            user.setLocale(TerminalContext.defaultLocale());
            user.setZoneId(TerminalContext.defaultZoneId());
            user.setRemark("auto register");
            user.setStatus(UserStatus.UNINIT);
            Long uid = this.beforeSave(user, username, details);
            if (uid == null) {
                uid = this.warlockUserBasisService.create(user);
                log.debug("auto register user authType={}, username={}, userId={}", new Object[]{authType, username, uid});
                this.afterSave(user, username, details, uid);
            }
            WarlockUserAuthnService.Authn authn = new WarlockUserAuthnService.Authn();
            authn.setAuthType(authType);
            authn.setUsername(username);
            authn.setExtraPara("");
            authn.setExtraUser("");
            authn.setExpiredDt(commit.getCommitDt().plusSeconds(this.warlockSecurityProp.getAutoregExpired().getSeconds()));
            authn.setFailedCnt(0);
            authn.setFailedMax(this.warlockSecurityProp.getAutoregMaxFailed());
            authn.setPassword(RandCode.human((int)16));
            Long aid = this.beforeSave(authn, username, details, uid);
            if (aid == null) {
                aid = this.warlockUserAuthnService.create(uid, authn);
                log.debug("auto register auth authType={}, username={}, authId={}", new Object[]{authType, username, aid});
                this.afterSave(authn, username, details, uid, aid);
            }
            WarlockAuthnService.Details result = new WarlockAuthnService.Details();
            result.setUserId(uid);
            result.setNickname(user.getNickname());
            result.setLocale(user.getLocale());
            result.setZoneId(user.getZoneId());
            result.setStatus(user.getStatus());
            result.setAuthType(authType);
            result.setUsername(authn.getUsername());
            result.setPassword(authn.getPassword());
            result.setPasssalt((String)AttributeHolder.tryAttr((TypedReg)WarlockGlobalAttribute.SaltByUid, (Object)uid));
            result.setExpiredDt(authn.getExpiredDt());
            return result;
        });
    }

    protected Long beforeSave(WarlockUserBasisService.Basis basis, String username, WingsAuthDetails details) {
        return null;
    }

    protected void afterSave(WarlockUserBasisService.Basis basis, String username, WingsAuthDetails details, long userId) {
    }

    protected Long beforeSave(WarlockUserAuthnService.Authn authn, String username, WingsAuthDetails details, long userId) {
        return null;
    }

    protected void afterSave(WarlockUserAuthnService.Authn authn, String username, WingsAuthDetails details, long userId, long authId) {
    }

    @Override
    public boolean accept(@NotNull Enum<?> authType, String username, WingsAuthDetails details) {
        return false;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public WarlockUserBasisService getWarlockUserBasisService() {
        return this.warlockUserBasisService;
    }

    @Generated
    public WarlockUserAuthnService getWarlockUserAuthnService() {
        return this.warlockUserAuthnService;
    }

    @Generated
    public WarlockSecurityProp getWarlockSecurityProp() {
        return this.warlockSecurityProp;
    }

    @Generated
    public JournalService getJournalService() {
        return this.journalService;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Autowired
    @Generated
    public void setWarlockUserBasisService(WarlockUserBasisService warlockUserBasisService) {
        this.warlockUserBasisService = warlockUserBasisService;
    }

    @Autowired
    @Generated
    public void setWarlockUserAuthnService(WarlockUserAuthnService warlockUserAuthnService) {
        this.warlockUserAuthnService = warlockUserAuthnService;
    }

    @Autowired
    @Generated
    public void setWarlockSecurityProp(WarlockSecurityProp warlockSecurityProp) {
        this.warlockSecurityProp = warlockSecurityProp;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }
}

