/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.admin;

import io.swagger.v3.oas.annotations.Operation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.event.EventPublishHelper;
import pro.fessional.wings.slardar.event.tweak.TweakClockEvent;
import pro.fessional.wings.slardar.event.tweak.TweakLoggerEvent;
import pro.fessional.wings.slardar.event.tweak.TweakStackEvent;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.warlock.mvc-tweak", value=false)
public class AdminTweakController {
    @Operation(summary="Tweak the logging level at the thread level", description="# Usage\nset log level by userId, reset to the original setting if level==OFF.\n## Params\n* @param userId - required, MAX_VALUE for all user\n* @param level - optional, e.g. TRACE, DEBUG, INFO, WARN, ERROR and OFF\n")
    @PostMapping(value={"${wings.warlock.urlmap.admin-tweak-logger}"})
    @ResponseBody
    public R<Void> adminTweakLogger(@RequestBody TweakLoggerEvent ev) {
        EventPublishHelper.SyncSpring.publishEvent((Object)ev);
        return R.OK;
    }

    @Operation(summary="Tweak the clock at the thread level", description="# Usage\nSet Clock by userId, reset to the original setting if mills==0\nCondition, mills in the next 3650 days (315360000000), before 1980\n(1) milliseconds difference from the system clock\n(2) fixed time (from 1970-01-01, after 1980)\n(3) 0 means reset setting, restores the original system settings.\n## Params\n* @param userId - required, MAX_VALUE for all user\n* @param mills - required, millisecond\n")
    @PostMapping(value={"${wings.warlock.urlmap.admin-tweak-clock}"})
    @ResponseBody
    public R<Void> adminTweakClock(@RequestBody TweakClockEvent ev) {
        EventPublishHelper.SyncSpring.publishEvent((Object)ev);
        return R.OK;
    }

    @Operation(summary="Tweak ExceptionStack at the thread level", description="# Usage\nTweak Stack of Exception by userId, reset to the original setting if stack==null\n## Params\n* @param userId - required, MAX_VALUE for all user\n* @param stack - optional, whether have stack\n")
    @PostMapping(value={"${wings.warlock.urlmap.admin-tweak-stack}"})
    @ResponseBody
    public R<Void> adminTweakStack(@RequestBody TweakStackEvent ev) {
        EventPublishHelper.SyncSpring.publishEvent((Object)ev);
        return R.OK;
    }
}

