/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.auth;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.warlock.service.auth.WarlockOauthService;

@Controller
@ConditionalWingsEnabled(abs="wings.enabled.warlock.mvc-oauth")
public class SimpleOauthController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleOauthController.class);
    protected WarlockOauthService warlockOauthService;

    @Operation(summary="Simple simulation of Oauth2 AuthorizationCode", description="# Usage\nsee https://docs.github.com/en/developers/apps/building-oauth-apps/authorizing-oauth-apps\nsee https://www.oauth.com/oauth2-servers/authorization/the-authorization-response\n* Default standard 302 redirect\n* return json if Accept: application/json\n* return xml if Accept: application/xml\n* return error, error_description if error\n## Params\n* @param client_id  - Required. The client ID\n* @param redirect_uri - redirect_uri if 302, or in json\n* @param scope - scope seperated by space\n* @param state - anti SCRF, return the raw value\n* @header Accept  - help to content type\n## Returns\n* @return {302} redirect to redirect_uri\n* @return {200} json/xml\n")
    @RequestMapping(value={"${wings.warlock.urlmap.oauth-authorize}"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseEntity<String> authorize(@RequestParam(value="client_id") String clientId, @RequestParam(value="redirect_uri", required=false) String redirectUri, @RequestParam(value="scope", required=false) String scope, @RequestParam(value="state", required=false) String state, @RequestHeader(value="Accept", required=false) String accept, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String sid = session != null ? session.getId() : null;
        WarlockOauthService.OAuth data = this.warlockOauthService.authorizeCode(clientId, scope, redirectUri, sid);
        data.put("state", state);
        return ResponseHelper.flatResponse((Map)data, (String)accept, (String)redirectUri);
    }

    @Operation(summary="Simple simulation of Oauth2 authorization-code and client-credentials", description="# Usage\nsee https://docs.github.com/en/developers/apps/building-oauth-apps/authorizing-oauth-apps\nsee https://www.oauth.com/oauth2-servers/access-tokens/authorization-code-request/\nsee https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/\n* Default standard 302 redirect\n* return json if Accept: application/json\n* return xml if Accept: application/xml\n* return error, error_description if error\n* during the validity period (defaut 1H), can refresh the code by passing access_token as the code.\n## Params\n* @param client_id  - Required. The client ID\n* @param client_secret  - Required. The client secret\n* @param code - authorization_code if not empty, otherwise client_credentials\n* @param redirect_uri - redirect or in json\n* @header Accept  - help to content type\n## Returns\n* @return {302} redirect to redirect_uri\n* @return {200} json/xml\n")
    @RequestMapping(value={"${wings.warlock.urlmap.oauth-access-token}"}, method={RequestMethod.POST})
    public ResponseEntity<?> accessToken(@RequestParam(value="client_id") String clientId, @RequestParam(value="client_secret") String clientSecret, @RequestParam(value="code", required=false) String code, @RequestParam(value="redirect_uri", required=false) String redirectUri, @RequestHeader(value="Accept", required=false) String accept) {
        WarlockOauthService.OAuth data = this.warlockOauthService.accessToken(clientId, clientSecret, code);
        return ResponseHelper.flatResponse((Map)data, (String)accept, (String)redirectUri);
    }

    @Operation(summary="Revoke AuthorizationCode or AccessToken in case of Token leakage", description="# Usage\n* Default standard 302 redirect\n* return json if Accept: application/json\n* return xml if Accept: application/xml\n* return error, error_description if error\n## Params\n* @param code - Required. valid AuthorizationCode or AccessToken\n* @param redirect_uri - redirect or in json\n* @header Accept  - help to content type\n## Returns\n* @return {302} redirect to redirect_uri\n* @return {200} json/xml\n")
    @RequestMapping(value={"${wings.warlock.urlmap.oauth-revoke-token}"}, method={RequestMethod.POST})
    public ResponseEntity<String> revokeToken(@RequestParam(value="client_id") String clientId, @RequestParam(value="code") String code, @RequestParam(value="redirect_uri", required=false) String redirectUri, @RequestHeader(value="Accept", required=false) String accept) {
        WarlockOauthService.OAuth data = this.warlockOauthService.revokeToken(clientId, code);
        return ResponseHelper.flatResponse((Map)data, (String)accept, (String)redirectUri);
    }

    @Autowired
    @Generated
    public void setWarlockOauthService(WarlockOauthService warlockOauthService) {
        this.warlockOauthService = warlockOauthService;
    }
}

