/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.listener;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.core.Authentication;
import pro.fessional.wings.slardar.fastjson.FastJsonHelper;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthToken;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;

public class WarlockFailedLoginListener
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarlockFailedLoginListener.class);
    protected WarlockAuthnService warlockAuthnService;

    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        String details;
        Object source = event.getSource();
        if (!(source instanceof WingsBindAuthToken)) {
            log.debug("skip non-wings-source, type={}", (Object)source.getClass().getName());
            return;
        }
        WingsBindAuthToken src = (WingsBindAuthToken)source;
        Authentication authn = event.getAuthentication();
        if (authn == null) {
            return;
        }
        Object dtl = authn.getDetails();
        if (dtl instanceof WingsAuthDetails) {
            WingsAuthDetails authDetails = (WingsAuthDetails)dtl;
            Map meta = authDetails.getMetaData();
            details = JSON.toJSONString((Object)meta, (JSONWriter.Feature[])FastJsonHelper.DefaultWriter());
        } else {
            details = dtl.toString();
        }
        this.warlockAuthnService.onFailure(src.getAuthType(), src.getName(), details);
    }

    @Autowired
    @Generated
    public void setWarlockAuthnService(WarlockAuthnService warlockAuthnService) {
        this.warlockAuthnService = warlockAuthnService;
    }
}

