/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.userdetails;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.security.PasssaltEncoder;
import pro.fessional.wings.slardar.security.PasswordHelper;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.slardar.security.impl.DefaultWingsUserDetails;
import pro.fessional.wings.warlock.event.auth.WarlockNonceSendEvent;
import pro.fessional.wings.warlock.service.auth.impl.DefaultUserDetailsCombo;

public class NonceUserDetailsCombo
extends DefaultUserDetailsCombo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonceUserDetailsCombo.class);
    @NotNull
    private final Cache cache;
    @NotNull
    private Set<Enum<?>> acceptNonceType = Collections.emptySet();
    protected PasswordEncoder passwordEncoder;
    protected PasssaltEncoder passsaltEncoder;
    protected WingsAuthTypeParser authTypeParser;

    @Nullable
    public UserDetails postAudit(@NotNull UserDetails useDetail, String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
        if (authType != Null.Enm && !this.acceptNonceType.contains(authType)) {
            return useDetail;
        }
        String key = this.cacheKey(authType, useDetail.getUsername());
        WarlockNonceSendEvent event = (WarlockNonceSendEvent)this.cache.get((Object)key, WarlockNonceSendEvent.class);
        if (event == null) {
            return useDetail;
        }
        this.cache.evict((Object)key);
        if (event.getExpired() < ThreadNow.millis()) {
            log.info("nonce expired username={}", (Object)useDetail.getUsername());
            return useDetail;
        }
        if (useDetail instanceof DefaultWingsUserDetails) {
            DefaultWingsUserDetails details = (DefaultWingsUserDetails)useDetail;
            log.debug("nonce change password, username={}", (Object)useDetail.getUsername());
            PasswordHelper helper = new PasswordHelper(this.passwordEncoder, this.passsaltEncoder);
            details.setPassword(helper.hash(event.getNonce(), details.getPasssalt()));
        }
        return useDetail;
    }

    @EventListener
    public void handleNonceSendEvent(WarlockNonceSendEvent event) {
        String key = this.cacheKey(event.getAuthType(), event.getUsername());
        this.cache.put((Object)key, (Object)event);
        log.info("put WarlockNonceSendEvent to cache={}, key={}", (Object)this.cache.getName(), (Object)key);
    }

    private String cacheKey(Enum<?> authType, String username) {
        return username + "@" + this.authTypeParser.parse(authType);
    }

    @Generated
    public void setAcceptNonceType(@NotNull Set<Enum<?>> acceptNonceType) {
        if (acceptNonceType == null) {
            throw new NullPointerException("acceptNonceType is marked non-null but is null");
        }
        this.acceptNonceType = acceptNonceType;
    }

    @NotNull
    @Generated
    public Cache getCache() {
        return this.cache;
    }

    @NotNull
    @Generated
    public Set<Enum<?>> getAcceptNonceType() {
        return this.acceptNonceType;
    }

    @Generated
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Generated
    public PasssaltEncoder getPasssaltEncoder() {
        return this.passsaltEncoder;
    }

    @Generated
    public WingsAuthTypeParser getAuthTypeParser() {
        return this.authTypeParser;
    }

    @Generated
    public NonceUserDetailsCombo(@NotNull Cache cache) {
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        this.cache = cache;
    }

    @Autowired
    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Autowired
    @Generated
    public void setPasssaltEncoder(PasssaltEncoder passsaltEncoder) {
        this.passsaltEncoder = passsaltEncoder;
    }

    @Autowired
    @Generated
    public void setAuthTypeParser(WingsAuthTypeParser authTypeParser) {
        this.authTypeParser = authTypeParser;
    }
}

