/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.mirana.tk.TicketHelp;
import pro.fessional.wings.silencer.encrypt.SecretProvider;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.warlock.service.auth.WarlockTicketService;
import pro.fessional.wings.warlock.service.auth.impl.SimpleTicketServiceImpl;
import pro.fessional.wings.warlock.service.auth.impl.WarlockOauthServiceImpl;
import pro.fessional.wings.warlock.spring.prop.WarlockTicketProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class WarlockOauthTicketConfiguration {
    private static final Log log = LogFactory.getLog(WarlockOauthTicketConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public WarlockOauthServiceImpl warlockOauthService(WarlockTicketProp warlockTicketProp) {
        log.info((Object)"WarlockShadow spring-bean warlockOauthService");
        WarlockOauthServiceImpl bean = new WarlockOauthServiceImpl();
        bean.setAuthCodeTtl(warlockTicketProp.getCodeTtl());
        bean.setAccessTokenTtl(warlockTicketProp.getTokenTtl());
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public SimpleTicketServiceImpl warlockTicketService(WarlockTicketProp warlockTicketProp, SecretProvider secretProvider) {
        log.info((Object)"WarlockShadow spring-bean warlockTicketService");
        SimpleTicketServiceImpl bean = new SimpleTicketServiceImpl();
        bean.setAuthorizeCodeMax(warlockTicketProp.getCodeMax());
        bean.setAccessTokenMax(warlockTicketProp.getTokenMax());
        String key = secretProvider.tryGet("ticket");
        if (key == null || key.isBlank()) {
            log.info((Object)"WarlockShadow spring-conf random aes-key, may fail api-call in cluster");
            key = RandCode.strong((int)32);
        }
        bean.setHelper((TicketHelp.Helper<String>)new TicketHelp.Ah1Help(warlockTicketProp.getPubMod(), key));
        for (Map.Entry<String, WarlockTicketService.Pass> en : warlockTicketProp.getClient().entrySet()) {
            WarlockTicketService.Pass pass = en.getValue();
            String client = en.getKey();
            String secret = pass.getSecret();
            if (secret == null || secret.isEmpty()) {
                log.warn((Object)("WarlockShadow spring-conf skip warlockTicketService.client=" + client + " for empty secret"));
                continue;
            }
            pass.setClient(client);
            log.info((Object)("WarlockShadow spring-conf warlockTicketService.client=" + client));
            bean.addClient(pass);
        }
        return bean;
    }
}

