/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.concur.impl.RighterInterceptor;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.warlock.controller.MvcController;
import pro.fessional.wings.warlock.errorhandle.auto.BindExceptionAdvice;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class WarlockOtherBeanConfiguration {
    private static final Log log = LogFactory.getLog(WarlockOtherBeanConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public RighterInterceptor.SecretProvider righterSecretProvider() {
        log.info((Object)"WarlockShadow spring-bean righterSecretProvider");
        return ss -> {
            Long uid = SecurityContextUtil.getUserId((boolean)false);
            return uid == null ? null : ss.getId() + uid;
        };
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    @ComponentScan(basePackageClasses={MvcController.class})
    public static class MvcRestScan {
        public MvcRestScan() {
            log.info((Object)"WarlockShadow spring-scan controller");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    @ComponentScan(basePackageClasses={BindExceptionAdvice.class})
    public static class BindingErrorScan {
        public BindingErrorScan() {
            log.info((Object)"WarlockShadow spring-scan BindExceptionAdvice");
        }
    }
}

