/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.data.Null;
import pro.fessional.wings.silencer.runner.ApplicationRunnerOrdered;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.help.CommonPropHelper;
import pro.fessional.wings.slardar.security.WingsAuthDetailsSource;
import pro.fessional.wings.slardar.servlet.request.FakeHttpServletRequest;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.slardar.spring.conf.WingsBindLoginConfigurer;
import pro.fessional.wings.slardar.spring.help.SecurityConfigHelper;
import pro.fessional.wings.warlock.spring.conf.HttpSecurityCustomizer;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class WarlockSecurityConfConfiguration {
    private static final Log log = LogFactory.getLog(WarlockSecurityConfConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.warlock.sec-web-auto")
    public WebSecurityCustomizer warlockWebCustomizer(WarlockSecurityProp securityProp, ObjectProvider<HttpFirewall> httpFirewall) {
        log.info((Object)"WarlockShadow spring-bean warlockWebCustomizer");
        return web -> {
            HttpFirewall firewall;
            Map<String, String> webIgnore;
            if (securityProp.isWebDebug()) {
                log.info((Object)"WarlockShadow conf WebSecurity, WebDebug=true");
                web.debug(true);
            }
            if (!(webIgnore = securityProp.getWebIgnore()).isEmpty()) {
                LinkedHashSet ignores = CommonPropHelper.onlyValue(webIgnore.values());
                log.info((Object)("WarlockShadow conf WebSecurity, ignoring=" + String.join((CharSequence)"\n,", ignores)));
                web.ignoring().requestMatchers((String[])ignores.toArray(String[]::new));
            }
            if ((firewall = (HttpFirewall)httpFirewall.getIfAvailable()) != null) {
                log.info((Object)("WarlockShadow conf WebSecurity, httpFirewall=" + String.valueOf(firewall.getClass())));
                web.httpFirewall(firewall);
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.warlock.sec-http-bind")
    @Order(value=-29999800)
    public HttpSecurityCustomizer warlockSecurityBindHttpConfigure(WarlockSecurityProp securityProp, SessionRegistry sessionRegistry, ObjectProvider<AuthenticationSuccessHandler> authenticationSuccessHandler, ObjectProvider<AuthenticationFailureHandler> authenticationFailureHandler, ObjectProvider<WingsAuthDetailsSource<?>> wingsAuthDetailsSource, ObjectProvider<LogoutSuccessHandler> logoutSuccessHandler, ObjectProvider<AccessDeniedHandler> accessDeniedHandler) {
        log.info((Object)"WarlockShadow spring-bean warlockSecurityBindHttpConfigure");
        return http -> {
            AuthenticationSuccessHandler authOkHandler = (AuthenticationSuccessHandler)authenticationSuccessHandler.getIfAvailable();
            AuthenticationFailureHandler authNgHandler = (AuthenticationFailureHandler)authenticationFailureHandler.getIfAvailable();
            WingsAuthDetailsSource authDetailSource = (WingsAuthDetailsSource)wingsAuthDetailsSource.getIfAvailable();
            LogoutSuccessHandler logoutOkHandler = (LogoutSuccessHandler)logoutSuccessHandler.getIfAvailable();
            log.info((Object)("WarlockShadow conf HttpSecurity, authenticationDetailsSource=" + String.valueOf(authDetailSource == null ? "null" : authDetailSource.getClass())));
            ((HttpSecurity)http.with((SecurityConfigurerAdapter)new WingsBindLoginConfigurer(), conf -> {
                ((WingsBindLoginConfigurer)conf.loginPage(securityProp.getLoginPage()).loginProcessingUrl(securityProp.getLoginProcUrl(), securityProp.getLoginProcMethod()).loginForward(securityProp.isLoginForward()).usernameParameter(securityProp.getUsernamePara()).passwordParameter(securityProp.getPasswordPara()).authenticationDetailsSource((AuthenticationDetailsSource)authDetailSource)).bindAuthTypeDefault(securityProp.mapAuthTypeDefault()).bindAuthTypeToEnums(securityProp.mapAuthTypeEnum());
                if (authOkHandler != null) {
                    log.info((Object)("WarlockShadow conf HttpSecurity, successHandler=" + String.valueOf(authOkHandler.getClass())));
                    conf.successHandler(authOkHandler);
                }
                if (authNgHandler != null) {
                    log.info((Object)("WarlockShadow conf HttpSecurity, failureHandler=" + String.valueOf(authNgHandler.getClass())));
                    conf.failureHandler(authNgHandler);
                }
            })).logout(conf -> {
                conf.logoutUrl(securityProp.getLogoutUrl()).clearAuthentication(true).invalidateHttpSession(true);
                if (logoutOkHandler != null) {
                    log.info((Object)("WarlockShadow conf HttpSecurity, logoutSuccessHandler=" + String.valueOf(logoutOkHandler.getClass())));
                    conf.logoutSuccessHandler(logoutOkHandler);
                }
            }).sessionManagement(conf -> conf.maximumSessions(securityProp.getSessionMaximum()).sessionRegistry(sessionRegistry).expiredSessionStrategy(event -> {
                HttpServletResponse response = event.getResponse();
                ResponseHelper.writeBodyUtf8((HttpServletResponse)response, (String)securityProp.getSessionExpiredBody());
            })).anonymous(conf -> {
                if (!securityProp.isAnonymous()) {
                    log.info((Object)"WarlockShadow conf HttpSecurity, disable anonymous");
                    conf.disable();
                }
            });
            AccessDeniedHandler deniedHandler = (AccessDeniedHandler)accessDeniedHandler.getIfAvailable();
            if (deniedHandler != null) {
                log.info((Object)("WarlockShadow conf exceptionHandling, accessDeniedHandler=" + String.valueOf(deniedHandler.getClass())));
                http.exceptionHandling(c -> c.accessDeniedHandler(deniedHandler));
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.warlock.sec-http-auth")
    @Order(value=-29999700)
    public HttpSecurityCustomizer warlockSecurityAuthHttpConfigure(WarlockSecurityProp securityProp) {
        log.info((Object)"WarlockShadow spring-bean warlockSecurityAuthHttpConfigure");
        return http -> http.authorizeHttpRequests(conf -> {
            LinkedHashSet authed;
            LinkedHashSet permed = CommonPropHelper.onlyValue(securityProp.getPermitAll().values());
            if (!permed.isEmpty()) {
                log.info((Object)("WarlockShadow conf HttpSecurity, bind PermitAll=" + String.join((CharSequence)"\n,", permed)));
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers((String[])permed.toArray(String[]::new))).permitAll();
            }
            if (!(authed = CommonPropHelper.onlyValue(securityProp.getAuthenticated().values())).isEmpty()) {
                log.info((Object)("WarlockShadow conf HttpSecurity, bind Authenticated=" + String.join((CharSequence)"\n,", authed)));
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers((String[])authed.toArray(String[]::new))).authenticated();
            }
            if (!securityProp.getAuthority().isEmpty()) {
                TreeMap<String, Set> urlPerm = new TreeMap<String, Set>();
                for (Map.Entry<String, Set<String>> entry : securityProp.getAuthority().entrySet()) {
                    String perm = entry.getKey();
                    for (String url : entry.getValue()) {
                        if (!CommonPropHelper.hasValue((String)url)) continue;
                        Set st = urlPerm.computeIfAbsent(url, k -> new HashSet());
                        st.add(perm);
                    }
                }
                for (Map.Entry<String, Set<String>> entry : urlPerm.descendingMap().entrySet()) {
                    String url = entry.getKey();
                    LinkedHashSet pms = CommonPropHelper.onlyValue((Collection)entry.getValue());
                    log.info((Object)("WarlockShadow conf HttpSecurity, bind url=" + url + ", any-permit=[" + String.join((CharSequence)",", pms) + "]"));
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{url})).hasAnyAuthority(pms.toArray(Null.StrArr));
                }
            }
        });
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.warlock.sec-http-base")
    @Order(value=-29999900)
    public HttpSecurityCustomizer warlockSecurityHttpBaseConfigure() {
        log.info((Object)"WarlockShadow spring-bean warlockSecurityHttpBaseConfigure");
        return http -> http.httpBasic(c -> {});
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.warlock.sec-http-auto")
    @Order(value=-29999600)
    public HttpSecurityCustomizer warlockSecurityAutoHttpConfigure(ObjectProvider<CsrfTokenRepository> csrf, ObjectProvider<RequestCache> cache) {
        log.info((Object)"WarlockShadow spring-bean warlockSecurityAutoHttpConfigure");
        return http -> {
            http.cors(c -> c.configurationSource(SecurityConfigHelper.corsPermitAll()));
            RequestCache rc = (RequestCache)cache.getIfAvailable();
            if (rc == null) {
                http.requestCache(RequestCacheConfigurer::disable);
                log.info((Object)"WarlockShadow conf HttpSecurity, requestCache disable");
            } else {
                http.requestCache(c -> c.requestCache(rc));
                log.info((Object)("WarlockShadow conf HttpSecurity, requestCache " + rc.getClass().getName()));
            }
            CsrfTokenRepository ct = (CsrfTokenRepository)csrf.getIfAvailable();
            if (ct == null) {
                http.csrf(AbstractHttpConfigurer::disable);
                log.info((Object)"WarlockShadow conf HttpSecurity, csrf disable");
            } else {
                http.csrf(c -> c.csrfTokenRepository(ct));
                log.info((Object)("WarlockShadow conf HttpSecurity, csrf " + ct.getClass().getName()));
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.warlock.sec-http-chain")
    @Order(value=-29999100)
    public SecurityFilterChain securityFilterChain(WarlockSecurityProp securityProp, HttpSecurity http, Map<String, HttpSecurityCustomizer> configures) throws Exception {
        log.info((Object)"WarlockShadow conf securityFilterChain, begin");
        for (Map.Entry<String, HttpSecurityCustomizer> en : configures.entrySet()) {
            log.info((Object)("WarlockShadow conf securityFilterChain, bean=" + en.getKey()));
            en.getValue().customize(http);
        }
        String anyRequest = securityProp.getAnyRequest();
        if (StringUtils.hasText((String)anyRequest)) {
            log.info((Object)("WarlockShadow conf securityFilterChain, anyRequest=" + anyRequest));
            String str = anyRequest.trim();
            if (!StringUtils.hasText((String)str) || "permitAll".equalsIgnoreCase(str)) {
                http.authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.anyRequest()).permitAll());
            } else if ("authenticated".equalsIgnoreCase(str)) {
                http.authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.anyRequest()).authenticated());
            } else if ("anonymous".equalsIgnoreCase(str)) {
                http.authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.anyRequest()).anonymous());
            } else if ("fullyAuthenticated".equalsIgnoreCase(str)) {
                http.authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.anyRequest()).fullyAuthenticated());
            } else {
                http.authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.anyRequest()).hasAnyAuthority(str.split("[, \t\r\n]+")));
            }
        }
        log.info((Object)"WarlockShadow conf securityFilterChain, done");
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.warlock.sec-check-url")
    public ApplicationRunnerOrdered securityCheckUrlRunner(WarlockSecurityProp securityProp, ApplicationContext ctx) {
        log.info((Object)"WarlockShadow spring-runs securityCheckUrlRunner");
        return new ApplicationRunnerOrdered(-90000000, ignored -> {
            String loginProcUrl;
            String logoutUrl;
            String ptn;
            log.info((Object)"WarlockShadow check security url config");
            LinkedHashMap<CallSite, String> matchers = new LinkedHashMap<CallSite, String>();
            LinkedHashMap<String, FakeHttpServletRequest> requests = new LinkedHashMap<String, FakeHttpServletRequest>();
            for (Map.Entry<String, String> entry : securityProp.getWebIgnore().entrySet()) {
                ptn = entry.getValue();
                if (!StringUtils.hasText((String)ptn)) continue;
                matchers.put((CallSite)((Object)("WebIgnore:" + entry.getKey())), ptn);
                requests.put(ptn, SecurityConfigHelper.fakeMatcherRequest((String)ptn));
            }
            for (Map.Entry<String, String> entry : securityProp.getPermitAll().entrySet()) {
                ptn = entry.getValue();
                if (!StringUtils.hasText((String)ptn)) continue;
                matchers.put((CallSite)((Object)("PermitAll:" + entry.getKey())), ptn);
                requests.put(ptn, SecurityConfigHelper.fakeMatcherRequest((String)ptn));
            }
            for (Map.Entry<String, String> entry : securityProp.getAuthenticated().entrySet()) {
                ptn = entry.getValue();
                if (!StringUtils.hasText((String)ptn)) continue;
                matchers.put((CallSite)((Object)("Authenticated:" + entry.getKey())), ptn);
                requests.put(ptn, SecurityConfigHelper.fakeMatcherRequest((String)ptn));
            }
            for (Map.Entry<String, Object> entry : securityProp.getAuthority().entrySet()) {
                int c = 0;
                String k = entry.getKey();
                for (String ptn2 : (Set)entry.getValue()) {
                    if (!StringUtils.hasText((String)ptn2)) continue;
                    matchers.put((CallSite)((Object)("Authority:" + k + "[" + c++ + "]")), ptn2);
                    requests.put(ptn2, SecurityConfigHelper.fakeMatcherRequest((String)ptn2));
                }
            }
            AtomicReference opt = new AtomicReference();
            SecurityConfigHelper.MatcherHelper matcherHelper = SecurityConfigHelper.MatcherHelper.of((ApplicationContext)ctx, opt);
            for (Map.Entry en : matchers.entrySet()) {
                String ptn3 = (String)en.getValue();
                requests.remove(ptn3);
                if (requests.isEmpty()) break;
                matcherHelper.requestMatchers(new String[]{ptn3});
                RequestMatcher mt = (RequestMatcher)opt.get();
                for (Map.Entry<String, String> entry : requests.entrySet()) {
                    if (!mt.matches((HttpServletRequest)entry.getValue())) continue;
                    log.warn((Object)((String)en.getKey() + "=" + ptn3 + " should not contain " + entry.getKey()));
                }
            }
            matchers.clear();
            requests.clear();
            String loginPage = securityProp.getLoginPage();
            if (StringUtils.hasText((String)loginPage)) {
                requests.put(loginPage, SecurityConfigHelper.fakeMatcherRequest((String)loginPage));
            }
            if (StringUtils.hasText((String)(logoutUrl = securityProp.getLogoutUrl()))) {
                requests.put(logoutUrl, SecurityConfigHelper.fakeMatcherRequest((String)logoutUrl));
            }
            if (StringUtils.hasText((String)(loginProcUrl = securityProp.getLoginProcUrl()))) {
                requests.put(loginProcUrl, SecurityConfigHelper.fakeMatcherRequest((String)loginProcUrl));
            }
            StringBuilder err = new StringBuilder();
            for (Map.Entry<String, String> entry : securityProp.getWebIgnore().entrySet()) {
                String string = entry.getValue();
                if (!StringUtils.hasText((String)string)) continue;
                matcherHelper.requestMatchers(new String[]{string});
                RequestMatcher mt = (RequestMatcher)opt.get();
                for (Map.Entry e : requests.entrySet()) {
                    if (!mt.matches((HttpServletRequest)e.getValue())) continue;
                    err.append("\nWebIgnore:").append(entry.getKey()).append(" should exclude ").append((String)e.getKey());
                }
            }
            String anyRequest = securityProp.getAnyRequest();
            if (!StringUtils.hasText((String)anyRequest) || "permitAll".equalsIgnoreCase(anyRequest) || "anonymous".equalsIgnoreCase(anyRequest)) {
                for (Map.Entry<String, String> entry : securityProp.getPermitAll().entrySet()) {
                    String ptn5 = entry.getValue();
                    if (!StringUtils.hasText((String)ptn5)) continue;
                    if (requests.isEmpty()) break;
                    matcherHelper.requestMatchers(new String[]{ptn5});
                    RequestMatcher mt = (RequestMatcher)opt.get();
                    Iterator it = requests.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry er = it.next();
                        if (!mt.matches((HttpServletRequest)er.getValue())) continue;
                        log.debug((Object)("WarlockShadow security url permit all include " + (String)er.getKey()));
                        it.remove();
                    }
                }
                if (!requests.isEmpty()) {
                    err.append("\nPermitAll should include urls: ").append(String.join((CharSequence)", ", requests.keySet()));
                }
            }
            if (!err.isEmpty()) {
                String string = err.toString();
                log.error((Object)string);
                throw new IllegalStateException("\nWarlockSecurityConfConfiguration has security url conflict to fix.\nor disable checking by `wings.enabled.warlock.sec-check-url=false`" + string);
            }
        });
    }
}

