/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.errorhandle;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.data.DataResult;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.pain.CodeException;
import pro.fessional.mirana.pain.HttpStatusException;
import pro.fessional.mirana.pain.MessageException;
import pro.fessional.mirana.text.JsonTemplate;
import pro.fessional.wings.slardar.context.LocaleZoneIdUtil;
import pro.fessional.wings.slardar.context.TerminalContextException;
import pro.fessional.wings.slardar.errcode.AuthnErrorEnum;
import pro.fessional.wings.slardar.errcode.AuthzErrorEnum;
import pro.fessional.wings.slardar.webmvc.SimpleExceptionResolver;
import pro.fessional.wings.slardar.webmvc.SimpleResponse;

public class DefaultExceptionResolver
extends SimpleExceptionResolver<Exception> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionResolver.class);
    protected final MessageSource messageSource;
    protected final ObjectMapper objectMapper;
    protected Handler handler = null;

    public DefaultExceptionResolver(SimpleResponse defaultResponse, MessageSource messageSource, ObjectMapper objectMapper) {
        super(defaultResponse);
        this.messageSource = messageSource;
        this.objectMapper = objectMapper;
    }

    protected SimpleResponse resolve(@NotNull Exception exception) {
        Throwable cause;
        SimpleResponse response = null;
        try {
            for (cause = exception; response == null && cause != null; cause = cause.getCause()) {
                if (cause instanceof HttpStatusException) {
                    HttpStatusException ex = (HttpStatusException)cause;
                    response = this.handle(ex);
                    continue;
                }
                if (cause instanceof TerminalContextException) {
                    TerminalContextException ex = (TerminalContextException)cause;
                    response = this.handleUnauthorized((Exception)ex);
                    continue;
                }
                if (cause instanceof CodeException) {
                    CodeException ex = (CodeException)cause;
                    response = this.handle(ex);
                    continue;
                }
                if (cause instanceof DataResult) {
                    DataResult ex = (DataResult)cause;
                    response = this.handle(ex);
                    continue;
                }
                if (cause instanceof AuthenticationException) {
                    AuthenticationException ex = (AuthenticationException)cause;
                    response = this.handleUnauthorized((Exception)ex);
                    continue;
                }
                if (!(cause instanceof AccessDeniedException)) continue;
                AccessDeniedException ex = (AccessDeniedException)cause;
                response = this.handleAccessDenied((Exception)ex);
            }
            if (response == null) {
                cause = exception;
            }
            if (this.handler != null) {
                response = this.handler.handle(cause, response);
            }
        }
        catch (Throwable e) {
            DummyBlock.ignore((Throwable)e);
        }
        if (response == null) {
            log.error("unhandled exception, response default", (Throwable)exception);
            response = this.defaultResponse;
        } else if (cause instanceof MessageException) {
            log.debug("handled MessageException, response simple", (Throwable)exception);
        } else {
            log.info("handled exception, response simple", (Throwable)exception);
        }
        return response;
    }

    protected SimpleResponse handle(DataResult<?> dre) {
        R ng = R.ng((String)dre.getMessage(), (String)dre.getCode(), (Object)dre.getData());
        String body = this.objectMapper.writeValueAsString((Object)ng);
        return new SimpleResponse(this.defaultResponse.getHttpStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handle(HttpStatusException cex) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            obj.putVal("code", (Object)cex.getCode());
            obj.putVal("message", (Object)this.resolveMessage((CodeException)cex));
        });
        return new SimpleResponse(cex.getStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handle(CodeException cex) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            obj.putVal("code", (Object)cex.getCode());
            obj.putVal("message", (Object)this.resolveMessage(cex));
        });
        return new SimpleResponse(this.defaultResponse.getHttpStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handleUnauthorized(Exception ignore) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            String code = AuthnErrorEnum.Unauthorized.getCode();
            obj.putVal("code", (Object)code);
            obj.putVal("message", (Object)this.resolveMessage(code, new Object[0]));
        });
        return new SimpleResponse(HttpStatus.UNAUTHORIZED.value(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handleAccessDenied(Exception ignore) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            String code = AuthzErrorEnum.AccessDenied.getCode();
            obj.putVal("code", (Object)code);
            obj.putVal("message", (Object)this.resolveMessage(code, new Object[0]));
        });
        return new SimpleResponse(HttpStatus.FORBIDDEN.value(), this.defaultResponse.getContentType(), body);
    }

    protected String resolveMessage(CodeException ce) {
        String code = ce.getI18nCode();
        if (code == null) {
            code = ce.getMessage();
        }
        if (code == null || code.isEmpty()) {
            return null;
        }
        return this.resolveMessage(code, Null.notNull((Object[])ce.getI18nArgs()));
    }

    protected String resolveMessage(String code, Object ... args) {
        Locale locale = (Locale)LocaleZoneIdUtil.LocaleNonnull.get();
        return this.messageSource.getMessage(code, args, locale);
    }

    @Generated
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public Handler getHandler() {
        return this.handler;
    }

    @Autowired(required=false)
    @Generated
    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public static interface Handler {
        @Nullable
        default public SimpleResponse handle(@NotNull Throwable cause, @Nullable SimpleResponse response) {
            return response;
        }
    }
}

