/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import pro.fessional.mirana.best.AssertState;
import pro.fessional.mirana.bits.Aes;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.help.CommonPropHelper;
import pro.fessional.wings.slardar.cache.WingsCache;
import pro.fessional.wings.slardar.security.WingsAuthDetailsSource;
import pro.fessional.wings.slardar.security.WingsAuthPageHandler;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.slardar.security.WingsAuthenticationEventPublisher;
import pro.fessional.wings.slardar.security.impl.ComboWingsAuthCheckService;
import pro.fessional.wings.slardar.security.impl.ComboWingsAuthDetailsSource;
import pro.fessional.wings.slardar.security.impl.ComboWingsAuthPageHandler;
import pro.fessional.wings.slardar.security.impl.ComboWingsUserDetailsService;
import pro.fessional.wings.slardar.security.impl.DefaultWingsAuthTypeParser;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;
import pro.fessional.wings.warlock.security.handler.AccessFailureHandler;
import pro.fessional.wings.warlock.security.handler.LoginFailureHandler;
import pro.fessional.wings.warlock.security.handler.LoginSuccessHandler;
import pro.fessional.wings.warlock.security.handler.LogoutOkHandler;
import pro.fessional.wings.warlock.security.justauth.AuthStateBuilder;
import pro.fessional.wings.warlock.security.listener.WarlockFailedLoginListener;
import pro.fessional.wings.warlock.security.listener.WarlockSuccessLoginListener;
import pro.fessional.wings.warlock.security.loginpage.JustAuthLoginPageCombo;
import pro.fessional.wings.warlock.security.loginpage.ListAllLoginPageCombo;
import pro.fessional.wings.warlock.security.userdetails.JustAuthUserAuthnAutoReg;
import pro.fessional.wings.warlock.security.userdetails.JustAuthUserDetailsCombo;
import pro.fessional.wings.warlock.security.userdetails.MemoryUserDetailsCombo;
import pro.fessional.wings.warlock.security.userdetails.NonceUserDetailsCombo;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;
import pro.fessional.wings.warlock.service.auth.impl.AuthAppPermChecker;
import pro.fessional.wings.warlock.service.auth.impl.AuthZonePermChecker;
import pro.fessional.wings.warlock.service.auth.impl.ComboWarlockAuthnService;
import pro.fessional.wings.warlock.service.auth.impl.ComboWarlockAuthzService;
import pro.fessional.wings.warlock.service.auth.impl.DefaultPermRoleCombo;
import pro.fessional.wings.warlock.service.auth.impl.DefaultUserAuthnAutoReg;
import pro.fessional.wings.warlock.service.auth.impl.DefaultUserDetailsCombo;
import pro.fessional.wings.warlock.service.auth.impl.MemoryTypedAuthzCombo;
import pro.fessional.wings.warlock.service.perm.WarlockPermNormalizer;
import pro.fessional.wings.warlock.spring.bean.WarlockJustAuthConfiguration;
import pro.fessional.wings.warlock.spring.prop.WarlockJustAuthProp;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class WarlockSecurityBeanConfiguration {
    private static final Log log = LogFactory.getLog(WarlockSecurityBeanConfiguration.class);
    public static final int OrderJustAuthUserAuthnAutoReg = -49999900;
    public static final int OrderMemoryUserDetailsCombo = -49999900;
    public static final int OrderNonceUserDetailsCombo = -49999800;
    public static final int OrderJustAuthUserDetailsCombo = -49999700;

    @Bean
    @ConditionalWingsEnabled
    public WingsAuthenticationEventPublisher authenticationEventPublisher(ApplicationContext context) {
        log.info((Object)"WarlockShadow spring-bean authenticationEventPublisher");
        return new WingsAuthenticationEventPublisher((ApplicationEventPublisher)context);
    }

    @Bean
    @ConditionalWingsEnabled
    public DefaultWingsAuthTypeParser wingsAuthTypeParser(WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean wingsAuthTypeParser");
        Map<String, Enum<?>> authType = prop.mapAuthTypeEnum();
        Enum<?> atd = prop.mapAuthTypeDefault();
        return new DefaultWingsAuthTypeParser(atd, authType);
    }

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnExpression(value="!'${wings.warlock.security.login-success-body}'.isEmpty()")
    public LoginSuccessHandler loginSuccessHandler() {
        log.info((Object)"WarlockShadow spring-bean loginSuccessHandler");
        return new LoginSuccessHandler();
    }

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnExpression(value="!'${wings.warlock.security.login-failure-body}'.isEmpty()")
    public LoginFailureHandler.Handler loginFailureHandlerDefault() {
        log.info((Object)"WarlockShadow spring-bean loginFailureHandlerDefault");
        return new LoginFailureHandler.DefaultHandler();
    }

    @Bean
    @ConditionalWingsEnabled
    public LoginFailureHandler loginFailureHandler() {
        log.info((Object)"WarlockShadow spring-bean loginFailureHandler");
        return new LoginFailureHandler();
    }

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnExpression(value="!'${wings.warlock.security.logout-success-body}'.isEmpty()")
    public LogoutOkHandler logoutSuccessHandler() {
        log.info((Object)"WarlockShadow spring-bean logoutSuccessHandler");
        return new LogoutOkHandler();
    }

    @Bean
    @ConditionalWingsEnabled
    public AccessFailureHandler accessDeniedHandler() {
        log.info((Object)"WarlockShadow spring-bean accessDeniedHandler");
        return new AccessFailureHandler();
    }

    @Bean
    @ConditionalWingsEnabled
    public WarlockPermNormalizer warlockPermNormalizer(GrantedAuthorityDefaults gad) {
        log.info((Object)"WarlockShadow spring-bean warlockPermNormalizer");
        WarlockPermNormalizer bean = new WarlockPermNormalizer();
        bean.setRolePrefix(gad.getRolePrefix());
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public ComboWarlockAuthnService comboWarlockAuthnService() {
        log.info((Object)"WarlockShadow spring-bean comboWarlockAuthnService");
        return new ComboWarlockAuthnService();
    }

    @Bean
    @ConditionalWingsEnabled
    public ComboWarlockAuthzService comboWarlockAuthzService(WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean comboWarlockAuthzService");
        ComboWarlockAuthzService bean = new ComboWarlockAuthzService();
        bean.setAuthorityRole(prop.isAuthorityRole());
        bean.setAuthorityPerm(prop.isAuthorityPerm());
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public DefaultPermRoleCombo defaultPermRoleCombo() {
        log.info((Object)"WarlockShadow spring-bean defaultPermRoleCombo");
        return new DefaultPermRoleCombo();
    }

    @Bean
    @ConditionalWingsEnabled(and={WarlockJustAuthConfiguration.class})
    public JustAuthUserAuthnAutoReg justAuthUserAuthnAutoReg() {
        log.info((Object)"WarlockShadow spring-bean justAuthUserAuthnAutoReg");
        JustAuthUserAuthnAutoReg bean = new JustAuthUserAuthnAutoReg();
        bean.setOrder(-49999900);
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public DefaultUserAuthnAutoReg defaultUserAuthnAutoReg() {
        log.info((Object)"WarlockShadow spring-bean defaultUserAuthnAutoReg");
        return new DefaultUserAuthnAutoReg();
    }

    @Bean
    @ConditionalWingsEnabled
    public MemoryUserDetailsCombo memoryUserDetailsCombo(WingsAuthTypeParser typeParser, WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean memoryUserDetailsCombo");
        MemoryUserDetailsCombo bean = new MemoryUserDetailsCombo();
        bean.setOrder(-49999900);
        for (Map.Entry<String, WarlockSecurityProp.Mu> en : prop.getMemUser().entrySet()) {
            log.info((Object)("WarlockShadow conf add MemUser=" + en.getKey()));
            WarlockSecurityProp.Mu mu = en.getValue();
            Set<String> ats = mu.getAuthType();
            if (ats == null || ats.isEmpty()) {
                ats = Collections.singleton("");
            }
            for (String at : ats) {
                WarlockAuthnService.Details dtl = new WarlockAuthnService.Details();
                dtl.setUserId(mu.getUserId());
                dtl.setAuthType(typeParser.parse(at));
                dtl.setUsername(mu.getUsername());
                dtl.setPassword(mu.getPassword());
                dtl.setStatus(mu.getStatus());
                dtl.setNickname(StringUtils.hasText((String)mu.getNickname()) ? mu.getNickname() : mu.getUsername());
                dtl.setPasssalt(mu.getPasssalt());
                dtl.setLocale(mu.getLocale());
                dtl.setZoneId(mu.getZoneId());
                dtl.setExpiredDt(mu.getExpired());
                bean.addUser(dtl);
            }
        }
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public NonceUserDetailsCombo nonceUserDetailsCombo(WarlockSecurityProp prop, Map<String, CacheManager> managers) {
        log.info((Object)"WarlockShadow spring-bean nonceUserDetailsCombo");
        String cn = WingsCache.Naming.join((String[])new String[]{prop.getNonceCacheLevel(), NonceUserDetailsCombo.class.getName()});
        CacheManager cm = managers.get(prop.getNonceCacheManager());
        AssertState.notNull((Object)cn, (String)"nonce cache name must not be null");
        AssertState.notNull((Object)cm, (String)"nonce cache manager must not be null");
        Cache cache = cm.getCache(cn);
        AssertState.notNull((Object)cache, (String)"nonce cache must not be null");
        NonceUserDetailsCombo bean = new NonceUserDetailsCombo(cache);
        bean.setOrder(-49999800);
        bean.setAcceptNonceType(prop.mapNonceAuthEnum());
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled(and={WarlockJustAuthConfiguration.class})
    public JustAuthUserDetailsCombo justAuthUserDetailsCombo() {
        log.info((Object)"WarlockShadow spring-bean justAuthUserDetailsCombo");
        JustAuthUserDetailsCombo bean = new JustAuthUserDetailsCombo();
        bean.setOrder(-49999700);
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public DefaultUserDetailsCombo defaultUserDetailsCombo(WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean defaultUserDetailsCombo");
        DefaultUserDetailsCombo bean = new DefaultUserDetailsCombo();
        bean.setAutoRegisterType(prop.mapAutoregAuthEnum());
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    @Order(value=-49999990)
    public AuthZonePermChecker authZonePermChecker(WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean authZonePermChecker");
        AuthZonePermChecker bean = new AuthZonePermChecker();
        bean.setZonePerm(prop.getZonePerm());
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    @Order(value=-49999980)
    public AuthAppPermChecker authAppPermChecker(@Value(value="${spring.application.name:wings-default}") String appName, WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean authAppPermChecker");
        AuthAppPermChecker bean = new AuthAppPermChecker();
        HashSet<String> perms = new HashSet<String>();
        AntPathMatcher matcher = new AntPathMatcher();
        for (Map.Entry<String, Set<String>> en : prop.getAppPerm().entrySet()) {
            String ptn = en.getKey();
            if (!matcher.match(ptn, appName)) continue;
            log.info((Object)("WarlockShadow conf authAppPermChecker, " + appName + " matches " + ptn));
            perms.addAll((Collection<String>)en.getValue());
        }
        bean.setAppPerm(perms);
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public ComboWingsAuthCheckService comboWingsAuthCheckService(ObjectProvider<ComboWingsAuthCheckService.Combo> combos) {
        log.info((Object)"WarlockShadow spring-bean comboWingsAuthCheckService");
        List list = combos.orderedStream().collect(Collectors.toList());
        ComboWingsAuthCheckService bean = new ComboWingsAuthCheckService();
        bean.setCombos(list);
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public ComboWingsUserDetailsService wingsUserDetailsService(ObjectProvider<ComboWingsUserDetailsService.Combo<?>> combos) {
        log.info((Object)"WarlockShadow spring-bean wingsUserDetailsService");
        ComboWingsUserDetailsService uds = new ComboWingsUserDetailsService();
        combos.orderedStream().forEach(it -> {
            log.info((Object)("WarlockShadow conf wingsUserDetailsService add " + it.getClass().getName()));
            uds.add(it);
        });
        return uds;
    }

    @Bean
    @ConditionalWingsEnabled
    public MemoryTypedAuthzCombo memoryTypedAuthzCombo(WingsAuthTypeParser typeParser, WarlockPermNormalizer normalizer, WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean memoryTypedAuthzCombo");
        MemoryTypedAuthzCombo bean = new MemoryTypedAuthzCombo();
        for (Map.Entry<String, WarlockSecurityProp.Ma> en : prop.getMemAuth().entrySet()) {
            String un;
            WarlockSecurityProp.Ma ma = en.getValue();
            Set<String> role = ma.getAuthRole().stream().map(normalizer::role).collect(Collectors.toSet());
            Set<String> perm = ma.getAuthPerm();
            long uid = ma.getUserId();
            log.info((Object)("WarlockShadow conf add MemAuth, userId=" + uid));
            bean.addAuthz(uid, role);
            bean.addAuthz(uid, perm);
            if (uid < 0L) {
                log.warn((Object)"should NOT use negative UserId");
            }
            if (StringUtils.hasText((String)(un = ma.getUsername()))) {
                String tm = ma.getAuthType();
                Enum at = typeParser.parse(tm);
                log.info((Object)("WarlockShadow conf add MemAuth, username=" + un + ", auth-type=" + tm));
                bean.addAuthz(un, at, role);
                bean.addAuthz(un, at, perm);
                continue;
            }
            log.info((Object)"WarlockShadow conf skip MemAuth, empty username");
        }
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public WingsAuthDetailsSource<?> wingsAuthDetailsSource(ObjectProvider<ComboWingsAuthDetailsSource.Combo<?>> combos, ObjectProvider<WingsRemoteResolver> rrs, ObjectProvider<LocaleResolver> lrp, WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean wingsAuthDetailsSource");
        ComboWingsAuthDetailsSource uds = new ComboWingsAuthDetailsSource();
        combos.orderedStream().forEach(it -> {
            log.info((Object)("WarlockShadow conf wingsAuthDetailsSource add " + it.getClass().getName()));
            uds.add(it);
        });
        HashSet<String> set = new HashSet<String>();
        set.add(prop.getPasswordPara());
        uds.setIgnoredMetaKey(set);
        rrs.ifAvailable(arg_0 -> ((ComboWingsAuthDetailsSource)uds).setWingsRemoteResolver(arg_0));
        lrp.ifAvailable(arg_0 -> ((ComboWingsAuthDetailsSource)uds).setLocaleResolver(arg_0));
        return uds;
    }

    @Bean
    @ConditionalWingsEnabled
    public AuthStateBuilder authStateBuilder(WarlockJustAuthProp prop, ObjectProvider<Aes> aesProvider) {
        log.info((Object)"WarlockShadow spring-bean authStateBuilder");
        AuthStateBuilder bean = new AuthStateBuilder(CommonPropHelper.onlyValue(prop.getSafeState()));
        Aes aes = (Aes)aesProvider.getIfAvailable();
        if (aes != null) {
            bean.setAes(aes);
            log.info((Object)"WarlockShadow conf authStateBuilder with Global Aes Bean");
        } else {
            log.info((Object)"WarlockShadow conf authStateBuilder with Random Aes Bean");
        }
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public WingsAuthPageHandler wingsAuthPageHandler(ObjectProvider<ComboWingsAuthPageHandler.Combo> combos) {
        log.info((Object)"WarlockShadow spring-bean wingsAuthPageHandler");
        ComboWingsAuthPageHandler uds = new ComboWingsAuthPageHandler();
        combos.orderedStream().forEach(it -> {
            log.info((Object)("WarlockShadow conf wingsAuthPageHandler add " + it.getClass().getName()));
            uds.add(it);
        });
        return uds;
    }

    @Bean
    @ConditionalWingsEnabled
    @Order(value=-29999990)
    public ListAllLoginPageCombo listAllLoginPageCombo() {
        log.info((Object)"WarlockShadow spring-bean listAllLoginPageCombo");
        return new ListAllLoginPageCombo();
    }

    @Bean
    @ConditionalWingsEnabled(and={WarlockJustAuthConfiguration.class})
    @Order(value=-29999980)
    public JustAuthLoginPageCombo justAuthLoginPageCombo() {
        log.info((Object)"WarlockShadow spring-bean justAuthLoginPageCombo");
        return new JustAuthLoginPageCombo();
    }

    @Bean
    @ConditionalWingsEnabled
    public GrantedAuthorityDefaults grantedAuthorityDefaults(WarlockSecurityProp prop) {
        log.info((Object)"WarlockShadow spring-bean grantedAuthorityDefaults");
        return new GrantedAuthorityDefaults(prop.getRolePrefix());
    }

    @Bean
    @ConditionalWingsEnabled
    public WarlockSuccessLoginListener warlockSuccessLoginListener() {
        log.info((Object)"WarlockShadow spring-bean warlockSuccessLoginListener");
        return new WarlockSuccessLoginListener();
    }

    @Bean
    @ConditionalWingsEnabled
    public WarlockFailedLoginListener warlockFailedLoginListener() {
        log.info((Object)"WarlockShadow spring-bean warlockFailedLoginListener");
        return new WarlockFailedLoginListener();
    }
}

