/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.auth;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.security.WingsAuthPageHandler;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.slardar.servlet.ContentTypeHelper;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;
import pro.fessional.wings.warlock.security.session.NonceTokenSessionHelper;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.warlock.mvc-login")
public class LoginPageController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginPageController.class);
    private final WingsAuthPageHandler wingsAuthPageHandler;
    private final WingsAuthTypeParser wingsAuthTypeParser;
    private final WingsRemoteResolver wingsRemoteResolver;
    private HttpSessionIdResolver httpSessionIdResolver;

    @Operation(summary="Default integrated login page, return list of supported types", description="# Usage\nLists the supported logon type. The response content is determined by the MediaType\ninferred from extName and request.ContentType. e.g. for `html` and `json` extensions,\nthe default implementation returns in json.\n## Params\n* @param extName - PathVariable, extName (.html, .json)\n## Returns\n* @return {401} auth failed and forward\n* @return {200} OK or redirect\n")
    @RequestMapping(value={"${wings.warlock.urlmap.auth-login-list}"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseEntity<?> loginList(@PathVariable(value="extName") String extName, HttpServletRequest request, HttpServletResponse response) {
        MediaType mt = ContentTypeHelper.mediaTypeByUri((String)extName);
        log.debug("default login-page media-type={}", (Object)mt);
        return this.wingsAuthPageHandler.response(Null.Enm, mt, request, response);
    }

    @Operation(summary="The specific login page, according to content-type and extName", description="# Usage\nGenerally used to construct the login entry, such as the 3rd path and param of the Oauth2 login;\nNote, `state` is an array, is spring supported http param array, such as `a=1&a=2&a=3`\n```bash\ncurl -X POST 'http://localhost:8084/auth/login-page.json' \\\n--data 'authType=github&state=/order-list&state=http://localhost:8080&state=&host=localhost:8080'\ncurl -X GET  \"http://localhost:8084/auth/login-page.json\\\n?authType=github&host=localhost:8080&state=/order-list&state=http://localhost%3A8080&state=\"\n```\n## Params\n* @param extName  - PathVariable extName (.html, .json)\n* @param authType - PathVariable auth type in the config (email, github)\n* @param authZone - help to grant perm\n* @param {string[]} state - Oauth2 state in MessageFormat: `state[0]` is Format's key, all `state` are Format's args;\n* @param host - Oauth2 redirect host to avoid CORS\n## Returns\n* @return {401} auth failed and forward\n* @return {200} OK or redirect\n")
    @RequestMapping(value={"${wings.warlock.urlmap.auth-login-page}"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseEntity<?> LoginPage(@PathVariable(value="extName") String extName, @PathVariable(value="authType") String authType, @RequestParam(value="authZone", required=false) String authZone, @RequestParam(value="state", required=false) List<String> state, @RequestParam(value="host", required=false) String host, HttpServletRequest request, HttpServletResponse response) {
        Enum em = this.wingsAuthTypeParser.parse(authType);
        MediaType mt = ContentTypeHelper.mediaTypeByUri((String)extName, (MediaType)MediaType.APPLICATION_JSON);
        log.debug("login-page authType={}, authZone={}, mediaType={}, state={}, host={}", new Object[]{authType, authZone, mt, state, host});
        return this.wingsAuthPageHandler.response(em, mt, request, response);
    }

    @Operation(summary="The specific login page, see wings.warlock.urlmap.auth-login-page", description="# Usage \nchange authTypefrom PathVariable to RequestParam\n")
    @RequestMapping(value={"${wings.warlock.urlmap.auth-login-page2}"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseEntity<?> LoginPage2(@PathVariable(value="extName") String extName, @RequestParam(value="authType", required=false) String authType, @RequestParam(value="authZone", required=false) String authZone, @RequestParam(value="state", required=false) List<String> state, @RequestParam(value="host", required=false) String host, HttpServletRequest request, HttpServletResponse response) {
        Enum em = this.wingsAuthTypeParser.parse(authType);
        MediaType mt = ContentTypeHelper.mediaTypeByUri((String)extName, (MediaType)MediaType.APPLICATION_JSON);
        log.debug("login-page authType={}, authZone={}, mediaType={}, state={}, host={}", new Object[]{authType, authZone, mt, state, host});
        return this.wingsAuthPageHandler.response(em, mt, request, response);
    }

    @Operation(summary="Verify that the one-time token is valid", description="# Usage\nUse Oauth2 state as the token and require the same ip, agent and other header as the original client.\nAfter successful verification, the session and cookie are in the header as a normal login\n## Params\n* @param token - RequestHeader Oauth2 state as token\n## Returns\n* @return {401} token is not-found, expired, or failed\n* @return {200 | Result(false, message='authing')} in authing\n* @return {200 | Result(true, data=sessionId)} success\n* @return {200 | Result(true, code='xxx', data=object)} other code/object\n")
    @PostMapping(value={"${wings.warlock.urlmap.auth-nonce-check}"})
    public ResponseEntity<R<?>> nonceCheck(@RequestHeader(value="token") String token, HttpServletRequest request, HttpServletResponse response) {
        R result = NonceTokenSessionHelper.authNonce(token, this.wingsRemoteResolver.resolveRemoteKey(request, new String[0]));
        if (result == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)R.NG());
        }
        R body = result;
        if (result.isSuccess()) {
            Object object;
            if (this.httpSessionIdResolver != null && (object = body.getData()) instanceof NonceTokenSessionHelper.SidData) {
                NonceTokenSessionHelper.SidData sd = (NonceTokenSessionHelper.SidData)object;
                this.httpSessionIdResolver.setSessionId(request, response, sd.getSid());
            }
            return ResponseEntity.ok((Object)body);
        }
        body = R.ng((String)"authing");
        return ResponseEntity.ok((Object)body);
    }

    @Generated
    public LoginPageController(WingsAuthPageHandler wingsAuthPageHandler, WingsAuthTypeParser wingsAuthTypeParser, WingsRemoteResolver wingsRemoteResolver) {
        this.wingsAuthPageHandler = wingsAuthPageHandler;
        this.wingsAuthTypeParser = wingsAuthTypeParser;
        this.wingsRemoteResolver = wingsRemoteResolver;
    }

    @Autowired(required=false)
    @Generated
    public void setHttpSessionIdResolver(HttpSessionIdResolver httpSessionIdResolver) {
        this.httpSessionIdResolver = httpSessionIdResolver;
    }
}

