/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.listener;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import pro.fessional.wings.slardar.fastjson.FastJsonHelper;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;

public class WarlockSuccessLoginListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarlockSuccessLoginListener.class);
    protected WarlockAuthnService warlockAuthnService;

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Object object = event.getSource();
        if (!(object instanceof Authentication)) {
            return;
        }
        Authentication authn = (Authentication)object;
        Object principal = authn.getPrincipal();
        if (!(principal instanceof WingsUserDetails)) {
            log.debug("skip non-WingsUserDetails, type={}", (Object)principal.getClass().getName());
            return;
        }
        WingsUserDetails userDetails = (WingsUserDetails)principal;
        Enum authType = userDetails.getAuthType();
        long userId = userDetails.getUserId();
        if (authType == null) {
            log.warn("authType should NOT null, userId={}", (Object)userId);
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("authType", authType.name());
        dataMap.put("locale", userDetails.getLocale());
        dataMap.put("zoneid", userDetails.getZoneId());
        dataMap.put("nickname", userDetails.getNickname());
        dataMap.put("username", userDetails.getUsername());
        Object object2 = authn.getDetails();
        if (object2 instanceof WingsAuthDetails) {
            WingsAuthDetails authDetails = (WingsAuthDetails)object2;
            Map meta = authDetails.getMetaData();
            dataMap.putAll(meta);
        }
        this.warlockAuthnService.onSuccess(authType, userId, FastJsonHelper.string(dataMap));
    }

    @Autowired
    @Generated
    public void setWarlockAuthnService(WarlockAuthnService warlockAuthnService) {
        this.warlockAuthnService = warlockAuthnService;
    }
}

