/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.transaction.annotation.Transactional;
import pro.fessional.mirana.time.Sleep;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.impl.DefaultWingsUserDetails;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;
import pro.fessional.wings.warlock.service.auth.help.AuthnDetailsMapper;

public class ComboWarlockAuthnService
implements WarlockAuthnService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComboWarlockAuthnService.class);
    private List<Combo> combos = Collections.emptyList();
    private List<AutoReg> authAutoRegs = Collections.emptyList();
    private final long[] lastTiming = new long[10];

    @Override
    public WarlockAuthnService.Details load(@NotNull Enum<?> authType, String username) {
        Combo cmb;
        WarlockAuthnService.Details dtl = null;
        Iterator<Combo> iterator = this.combos.iterator();
        while (iterator.hasNext() && (dtl = (cmb = iterator.next()).load(authType, username)) == null) {
        }
        return dtl;
    }

    @Override
    public WarlockAuthnService.Details load(@NotNull Enum<?> authType, long userId) {
        Combo cmb;
        WarlockAuthnService.Details dtl = null;
        Iterator<Combo> iterator = this.combos.iterator();
        while (iterator.hasNext() && (dtl = (cmb = iterator.next()).load(authType, userId)) == null) {
        }
        return dtl;
    }

    @Override
    public void auth(DefaultWingsUserDetails userDetails, WarlockAuthnService.Details details) {
        if (userDetails == null || details == null) {
            return;
        }
        AuthnDetailsMapper.to(details, userDetails);
        switch (details.getStatus()) {
            case UNINIT: 
            case ACTIVE: 
            case INFIRM: 
            case UNSAFE: {
                userDetails.setEnabled(true);
                userDetails.setAccountNonExpired(true);
                userDetails.setAccountNonLocked(true);
                break;
            }
            case DANGER: {
                userDetails.setEnabled(true);
                userDetails.setAccountNonExpired(true);
                userDetails.setAccountNonLocked(false);
                break;
            }
            default: {
                userDetails.setEnabled(false);
                userDetails.setAccountNonExpired(false);
                userDetails.setAccountNonLocked(false);
            }
        }
        userDetails.setCredentialsNonExpired(details.getExpiredDt().isAfter(Now.localDateTime()));
    }

    @Override
    @Transactional
    public WarlockAuthnService.Details register(@NotNull Enum<?> authType, String username, WingsAuthDetails details) {
        for (AutoReg autoReg : this.authAutoRegs) {
            WarlockAuthnService.Details dt;
            if (!autoReg.accept(authType, username, details) || (dt = autoReg.create(authType, username, details)) == null) continue;
            log.debug("register by AutoReg={}", autoReg.getClass());
            return dt;
        }
        return null;
    }

    @Override
    public void onSuccess(@NotNull Enum<?> authType, long userId, String details) {
        for (Combo cmb : this.combos) {
            cmb.onSuccess(authType, userId, details);
        }
    }

    @Override
    public void onFailure(@NotNull Enum<?> authType, String username, String details) {
        long bgn = ThreadNow.millis();
        for (Combo cmb : this.combos) {
            cmb.onFailure(authType, username, details);
        }
        long cost = ThreadNow.millis() - bgn;
        this.timingAttack(cost);
    }

    private void timingAttack(long cost) {
        long slp;
        long sum = 0L;
        long cnt = 0L;
        for (long t : this.lastTiming) {
            if (t <= 0L) continue;
            sum += t;
            ++cnt;
        }
        long l = slp = cnt == 0L ? -1L : sum / cnt - cost;
        if (cost > 0L) {
            System.arraycopy(this.lastTiming, 0, this.lastTiming, 1, this.lastTiming.length - 1);
            this.lastTiming[0] = cost;
        }
        if (slp > 10L) {
            Sleep.ignoreInterrupt((long)slp);
        }
    }

    @Autowired(required=false)
    @Generated
    public void setCombos(List<Combo> combos) {
        this.combos = combos;
    }

    @Autowired(required=false)
    @Generated
    public void setAuthAutoRegs(List<AutoReg> authAutoRegs) {
        this.authAutoRegs = authAutoRegs;
    }

    public static interface Combo
    extends Ordered {
        public WarlockAuthnService.Details load(@NotNull Enum<?> var1, String var2);

        public WarlockAuthnService.Details load(@NotNull Enum<?> var1, long var2);

        public void onSuccess(@NotNull Enum<?> var1, long var2, String var4);

        public void onFailure(@NotNull Enum<?> var1, String var2, String var3);
    }

    public static interface AutoReg
    extends Ordered {
        public WarlockAuthnService.Details create(@NotNull Enum<?> var1, String var2, WingsAuthDetails var3);

        public boolean accept(@NotNull Enum<?> var1, String var2, WingsAuthDetails var3);
    }
}

