/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.auth;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;
import pro.fessional.wings.warlock.security.session.NonceTokenSessionHelper;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.warlock.mvc-proc")
public class AuthCheckController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthCheckController.class);
    private final WingsRemoteResolver wingsRemoteResolver;
    private HttpSessionIdResolver httpSessionIdResolver;

    @Operation(summary="Verify that the one-time token is valid", description="# Usage\nUse Oauth2 state as the token and require the same ip, agent and other header as the original client.\nAfter successful verification, the session and cookie are in the header as a normal login\n## Params\n* @param token - RequestHeader Oauth2 state as token\n## Returns\n* @return {401} token is not-found, expired, or failed\n* @return {200 | Result(false, message='authing')} in authing\n* @return {200 | Result(true, data=sessionId)} success\n* @return {200 | Result(true, code='xxx', data=object)} other code/object\n")
    @PostMapping(value={"${wings.warlock.urlmap.auth-nonce-check}"})
    public ResponseEntity<R<?>> nonceCheck(@RequestHeader(value="token") String token, HttpServletRequest request, HttpServletResponse response) {
        R result = NonceTokenSessionHelper.authNonce(token, this.wingsRemoteResolver.resolveRemoteKey(request, new String[0]));
        if (result == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)R.NG());
        }
        R body = result;
        if (result.isSuccess()) {
            Object object;
            if (this.httpSessionIdResolver != null && (object = body.getData()) instanceof NonceTokenSessionHelper.SidData) {
                NonceTokenSessionHelper.SidData sd = (NonceTokenSessionHelper.SidData)object;
                this.httpSessionIdResolver.setSessionId(request, response, sd.getSid());
            }
            return ResponseEntity.ok((Object)body);
        }
        body = R.ng((Object)"authing");
        return ResponseEntity.ok((Object)body);
    }

    @Operation(summary="check current session, return basic info if valid", description="# Usage\nunlike user-authed-user, this always returns 200, without session and username (for secure)\n## Returns\n* @return {200 | Result(Dto)} logined user and basis info\n* @return {200 | Result(false)} not logined")
    @PostMapping(value={"${wings.warlock.urlmap.auth-session-check}"})
    public R<Dto> sessionCheck() {
        WingsUserDetails wd = SecurityContextUtil.getUserDetails((boolean)false);
        if (wd == null) {
            return R.NG();
        }
        Dto dto = new Dto();
        dto.setNickname(wd.getNickname());
        dto.setLocale(wd.getLocale().toLanguageTag());
        ZoneId zid = wd.getZoneId();
        dto.setZoneid(zid.getId());
        dto.setOffset(ZonedDateTime.now(zid).getOffset().getTotalSeconds());
        Enum at = wd.getAuthType();
        if (at != null) {
            dto.setAuthtype(at.name());
        }
        return R.ok((Object)dto);
    }

    @Generated
    public AuthCheckController(WingsRemoteResolver wingsRemoteResolver) {
        this.wingsRemoteResolver = wingsRemoteResolver;
    }

    @Autowired(required=false)
    @Generated
    public void setHttpSessionIdResolver(HttpSessionIdResolver httpSessionIdResolver) {
        this.httpSessionIdResolver = httpSessionIdResolver;
    }

    @Schema(description="Basic info of login user")
    public static class Dto {
        @Schema(description="nickname", example="trydofor")
        private String nickname;
        @Schema(description="language, see java.util.Locale", example="zh-CN")
        private String locale;
        @Schema(description="timezone, see java.time.ZoneId", example="Asia/Shanghai")
        private String zoneid;
        @Schema(description="time offset in second to UTD", example="28800")
        private int offset;
        @Schema(description="auth type of current session", example="EMAIL")
        private String authtype;

        @Generated
        public Dto() {
        }

        @Generated
        public String getNickname() {
            return this.nickname;
        }

        @Generated
        public String getLocale() {
            return this.locale;
        }

        @Generated
        public String getZoneid() {
            return this.zoneid;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public String getAuthtype() {
            return this.authtype;
        }

        @Generated
        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        @Generated
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @Generated
        public void setZoneid(String zoneid) {
            this.zoneid = zoneid;
        }

        @Generated
        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Generated
        public void setAuthtype(String authtype) {
            this.authtype = authtype;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dto)) {
                return false;
            }
            Dto other = (Dto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            String this$nickname = this.getNickname();
            String other$nickname = other.getNickname();
            if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
                return false;
            }
            String this$locale = this.getLocale();
            String other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
                return false;
            }
            String this$zoneid = this.getZoneid();
            String other$zoneid = other.getZoneid();
            if (this$zoneid == null ? other$zoneid != null : !this$zoneid.equals(other$zoneid)) {
                return false;
            }
            String this$authtype = this.getAuthtype();
            String other$authtype = other.getAuthtype();
            return !(this$authtype == null ? other$authtype != null : !this$authtype.equals(other$authtype));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Dto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOffset();
            String $nickname = this.getNickname();
            result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
            String $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
            String $zoneid = this.getZoneid();
            result = result * 59 + ($zoneid == null ? 43 : $zoneid.hashCode());
            String $authtype = this.getAuthtype();
            result = result * 59 + ($authtype == null ? 43 : $authtype.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "AuthCheckController.Dto(nickname=" + this.getNickname() + ", locale=" + this.getLocale() + ", zoneid=" + this.getZoneid() + ", offset=" + this.getOffset() + ", authtype=" + this.getAuthtype() + ")";
        }
    }
}

