/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.errorhandle;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.i18n.I18nNotice;
import pro.fessional.mirana.pain.BadArgsException;
import pro.fessional.mirana.pain.BadStateException;
import pro.fessional.mirana.pain.HttpStatusException;
import pro.fessional.mirana.pain.MessageException;
import pro.fessional.mirana.text.JsonTemplate;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.silencer.message.MessageSourceHelper;
import pro.fessional.wings.slardar.context.TerminalContextException;
import pro.fessional.wings.slardar.errcode.AuthnErrorEnum;
import pro.fessional.wings.slardar.errcode.AuthzErrorEnum;
import pro.fessional.wings.slardar.servlet.request.RequestHelper;
import pro.fessional.wings.slardar.webmvc.SimpleExceptionResolver;
import pro.fessional.wings.slardar.webmvc.SimpleResponse;

public class DefaultExceptionResolver
extends SimpleExceptionResolver<Exception> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionResolver.class);
    protected final ObjectMapper objectMapper;
    protected Handler handler = null;

    public DefaultExceptionResolver(SimpleResponse defaultResponse, ObjectMapper objectMapper) {
        super(defaultResponse);
        this.objectMapper = objectMapper;
    }

    protected SimpleResponse resolve(@NotNull Exception exception, @NotNull HttpServletRequest request) {
        SimpleResponse response = null;
        Locale lang = RequestHelper.getLocale((HttpServletRequest)request, (boolean)true);
        try {
            for (Throwable cause = exception; response == null && cause != null; cause = cause.getCause()) {
                if (cause instanceof HttpStatusException) {
                    HttpStatusException ex = (HttpStatusException)cause;
                    response = this.handle(lang, ex);
                    continue;
                }
                if (cause instanceof TerminalContextException) {
                    TerminalContextException ex = (TerminalContextException)cause;
                    response = this.handleUnauthorized(lang, (Exception)ex);
                    continue;
                }
                if (cause instanceof I18nAware) {
                    response = this.handleI18nAware(lang, cause);
                    continue;
                }
                if (cause instanceof AuthenticationException) {
                    AuthenticationException ex = (AuthenticationException)cause;
                    response = this.handleUnauthorized(lang, (Exception)ex);
                    continue;
                }
                if (!(cause instanceof AccessDeniedException)) continue;
                AccessDeniedException ex = (AccessDeniedException)cause;
                response = this.handleAccessDenied(lang, (Exception)ex);
            }
            if (this.handler != null) {
                response = this.handler.handle(exception, response);
            }
        }
        catch (Throwable e) {
            DummyBlock.ignore((Throwable)e);
        }
        if (response == null) {
            log.error("unhandled exception, response default", (Throwable)exception);
            response = this.defaultResponse;
        } else if (exception instanceof MessageException) {
            log.debug("handled MessageException, response simple", (Throwable)exception);
        } else {
            log.info("handled exception, response simple", (Throwable)exception);
        }
        return response;
    }

    protected SimpleResponse handle(Locale lang, HttpStatusException cex) {
        String body = JsonTemplate.obj(obj -> {
            String msg;
            obj.putVal("success", (Object)false);
            String code = cex.getCode();
            if (EmptySugar.nonEmptyValue((String)code)) {
                obj.putVal("code", (Object)code);
            }
            if (EmptySugar.nonEmptyValue((String)(msg = this.resolveMessage(lang, (I18nAware)cex)))) {
                obj.putVal("message", (Object)msg);
            }
        });
        return new SimpleResponse(cex.getStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handleI18nAware(Locale lang, Throwable cex) {
        R r = R.ngError((Throwable)cex, (String)this.resolveErrorType(cex));
        r.applyLocale(lang, MessageSourceHelper.i18nSource());
        String body = this.objectMapper.writeValueAsString((Object)r);
        return new SimpleResponse(this.defaultResponse.getHttpStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handleUnauthorized(Locale lang, Exception ignore) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            String code = AuthnErrorEnum.Unauthorized.getCode();
            obj.putVal("code", (Object)code);
            obj.putVal("message", (Object)this.resolveMessage(lang, code, new Object[0]));
        });
        return new SimpleResponse(HttpStatus.UNAUTHORIZED.value(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handleAccessDenied(Locale lang, Exception ignore) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            String code = AuthzErrorEnum.AccessDenied.getCode();
            obj.putVal("code", (Object)code);
            obj.putVal("message", (Object)this.resolveMessage(lang, code, new Object[0]));
        });
        return new SimpleResponse(HttpStatus.FORBIDDEN.value(), this.defaultResponse.getContentType(), body);
    }

    protected String resolveMessage(Locale lang, I18nAware ce) {
        return ce.toString(lang, MessageSourceHelper.i18nSource());
    }

    protected String resolveMessage(Locale locale, String code, Object ... args) {
        return MessageSourceHelper.getMessage((String)code, (Object[])args, (Locale)locale);
    }

    protected String resolveErrorType(Throwable cex) {
        if (cex instanceof BadStateException || cex instanceof IllegalStateException) {
            return I18nNotice.Type.IllegalState.name();
        }
        if (cex instanceof BadArgsException || cex instanceof IllegalArgumentException) {
            return I18nNotice.Type.IllegalArgument.name();
        }
        return null;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public Handler getHandler() {
        return this.handler;
    }

    @Autowired(required=false)
    @Generated
    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public static interface Handler {
        @Nullable
        default public SimpleResponse handle(@NotNull Exception cause, @Nullable SimpleResponse response) {
            return response;
        }
    }
}

