/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.errorhandle;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import pro.fessional.mirana.i18n.I18nNotice;

public class I18nAwareHelper {
    @NotNull
    public static List<I18nNotice> notices(@NotNull BindingResult error) {
        List errors = error.getAllErrors();
        ArrayList<I18nNotice> notices = new ArrayList<I18nNotice>(errors.size() + 1);
        String type = I18nNotice.Type.Validation.name();
        for (ObjectError err : errors) {
            I18nNotice ntc = new I18nNotice();
            ntc.setType(type);
            ntc.setMessage(err.getDefaultMessage());
            ntc.setI18nCode(err.getCode());
            ntc.setI18nArgs(err.getArguments());
            if (err instanceof FieldError) {
                FieldError fe = (FieldError)err;
                ntc.setTarget(fe.getField());
            }
            notices.add(ntc);
        }
        return notices;
    }
}

