/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.errorhandle.auto;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.i18n.I18nNotice;
import pro.fessional.wings.warlock.errcode.CommonErrorEnum;
import pro.fessional.wings.warlock.errorhandle.I18nAwareHelper;

@ControllerAdvice(annotations={RestController.class})
@Order(value=-30000000)
public class BindExceptionAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BindExceptionAdvice.class);
    public static final int ORDER = -30000000;

    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class})
    public ResponseEntity<R<?>> bindException(BindException ex) {
        log.warn("bindException Advice", (Throwable)ex);
        List<I18nNotice> notices = I18nAwareHelper.notices((BindingResult)ex);
        R body = R.ngError(notices);
        return ResponseEntity.ok((Object)body);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<R<?>> httpMessageNotReadableException(HttpMessageNotReadableException ex) {
        log.warn("httpMessageNotReadableException Advice", (Throwable)ex);
        I18nNotice ntc = I18nNotice.of((I18nAware)CommonErrorEnum.MessageUnreadable);
        ntc.setType(I18nNotice.Type.Validation.name());
        ntc.setTarget("body");
        R body = R.ngError((I18nNotice)ntc);
        return ResponseEntity.ok((Object)body);
    }
}

