/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SafeHttpHelper {
    public static boolean isSafeRedirect(@NotNull String uri, Set<String> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return true;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)uri, (CharSequence)"http://") && !StringUtils.startsWithIgnoreCase((CharSequence)uri, (CharSequence)"https://")) {
            return false;
        }
        String hp = SafeHttpHelper.parseHostPort(uri);
        if (hp == null) {
            return false;
        }
        int p1 = hp.lastIndexOf(58);
        String h = p1 < 0 ? hp : hp.substring(0, p1);
        return hosts.contains(h);
    }

    public static String parseHostPort(String uri) {
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        int off = uri.indexOf("//");
        if (off <= 0) {
            return null;
        }
        int posBgn = off += 2;
        int posEnd = -1;
        boolean start = false;
        int len = uri.length();
        for (int i = off; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == '/') {
                if (!start) continue;
                posEnd = i;
                break;
            }
            if (c == '@') {
                posBgn = i;
                continue;
            }
            if (c == '#' || c == '?') {
                posEnd = i;
                break;
            }
            if (!start) {
                posBgn = i;
            }
            start = true;
        }
        if (posEnd < 0) {
            return uri.substring(posBgn);
        }
        return uri.substring(posBgn, posEnd);
    }
}

