/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.text.StringTemplate;
import pro.fessional.wings.slardar.errcode.AuthnErrorEnum;
import pro.fessional.wings.slardar.servlet.request.RequestHelper;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

public class LoginFailureHandler
implements AuthenticationFailureHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginFailureHandler.class);
    private List<Handler> handlers = new ArrayList<Handler>();

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        for (Handler hdl : this.handlers) {
            if (hdl.handle(request, response, exception)) break;
        }
    }

    @Autowired
    @Lazy
    @Generated
    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public static interface Handler
    extends Ordered {
        default public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public boolean handle(HttpServletRequest var1, HttpServletResponse var2, AuthenticationException var3);
    }

    public static class DefaultHandler
    implements Handler {
        protected WarlockSecurityProp warlockSecurityProp;
        protected ObjectMapper objectMapper;
        protected MessageSource messageSource;

        @Override
        public boolean handle(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
            String body = null;
            Locale lang = RequestHelper.getLocale((HttpServletRequest)request, (boolean)true);
            try {
                if (exception instanceof I18nAware) {
                    body = this.handleI18nAware(exception, lang);
                }
            }
            catch (Exception e) {
                DummyBlock.ignore((Throwable)e);
            }
            if (body == null) {
                body = this.handle(exception, lang);
            }
            ResponseHelper.writeBodyUtf8((HttpServletResponse)response, (String)body);
            return true;
        }

        protected String handleI18nAware(AuthenticationException dre, Locale lang) {
            R ng = R.ngError((Throwable)dre, (String)"Authentication");
            ng.applyLocale(lang, (arg_0, arg_1, arg_2, arg_3) -> ((MessageSource)this.messageSource).getMessage(arg_0, arg_1, arg_2, arg_3));
            return this.objectMapper.writeValueAsString((Object)ng);
        }

        protected String handle(AuthenticationException exception, Locale lang) {
            String msg;
            String code;
            if (exception instanceof BadCredentialsException) {
                code = AuthnErrorEnum.BadCredentials.getCode();
                msg = this.messageSource.getMessage(code, (Object[])Null.StrArr, lang);
            } else if (exception instanceof LockedException) {
                code = AuthnErrorEnum.Locked.getCode();
                msg = this.messageSource.getMessage(code, (Object[])Null.StrArr, lang);
            } else if (exception instanceof DisabledException) {
                code = AuthnErrorEnum.Disabled.getCode();
                msg = this.messageSource.getMessage(code, (Object[])Null.StrArr, lang);
            } else if (exception instanceof AccountExpiredException) {
                code = AuthnErrorEnum.Expired.getCode();
                msg = this.messageSource.getMessage(code, (Object[])Null.StrArr, lang);
            } else if (exception instanceof CredentialsExpiredException) {
                code = AuthnErrorEnum.CredentialsExpired.getCode();
                msg = this.messageSource.getMessage(code, (Object[])Null.StrArr, lang);
            } else {
                code = null;
                msg = exception.getMessage();
            }
            if (code == null) {
                return StringTemplate.dyn((String)this.warlockSecurityProp.getLoginFailureBody()).bindStr("{message}", (Object)msg).toString();
            }
            R ng = R.ngCode((String)code);
            ng.setMessage(msg);
            return this.objectMapper.writeValueAsString((Object)ng);
        }

        @Autowired
        @Generated
        public void setWarlockSecurityProp(WarlockSecurityProp warlockSecurityProp) {
            this.warlockSecurityProp = warlockSecurityProp;
        }

        @Autowired
        @Generated
        public void setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Autowired
        @Generated
        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }
    }
}

