/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.slardar.spring.prop.SlardarSessionProp;
import pro.fessional.wings.warlock.security.SafeHttpHelper;
import pro.fessional.wings.warlock.security.handler.NonceLoginSuccessHandler;
import pro.fessional.wings.warlock.spring.prop.WarlockJustAuthProp;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

public class LoginSuccessHandler
extends NonceLoginSuccessHandler
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginSuccessHandler.class);
    protected WarlockSecurityProp warlockSecurityProp;
    protected WarlockJustAuthProp warlockJustAuthProp;
    protected SlardarSessionProp slardarSessionProp;

    @Override
    protected void onResponse(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull Authentication aun, @NotNull NonceLoginSuccessHandler.State state) throws IOException, ServletException {
        String cts = state.getStateClient();
        if (cts != null && !cts.isEmpty()) {
            if (cts.startsWith("/") || this.isSafeRedirect(cts)) {
                log.debug("redirect to {}", (Object)cts);
                res.sendRedirect(cts);
            } else {
                this.writeResponseBody(req, res, aun, state, cts);
            }
        } else if (this.warlockSecurityProp.isLoginSuccessRedirect()) {
            super.onResponse(req, res, aun, state);
        } else {
            this.writeResponseBody(req, res, aun, state, this.warlockSecurityProp.getLoginSuccessBody());
        }
    }

    protected boolean isSafeRedirect(String state) {
        return SafeHttpHelper.isSafeRedirect(state, this.warlockJustAuthProp.getSafeHost());
    }

    protected void writeResponseBody(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull Authentication aun, @NotNull NonceLoginSuccessHandler.State state, @NotNull String body) {
        ResponseHelper.writeBodyUtf8((HttpServletResponse)res, (String)body);
    }

    public void afterPropertiesSet() {
        if (this.warlockSecurityProp != null && this.warlockSecurityProp.isLoginSuccessRedirect()) {
            String ld = this.warlockSecurityProp.getLoginSuccessRedirectDefault();
            if (StringUtils.hasText((String)ld)) {
                this.setDefaultTargetUrl(ld);
            }
            String lp = this.warlockSecurityProp.getLoginSuccessRedirectParam();
            if (StringUtils.hasText((String)ld)) {
                this.setTargetUrlParameter(lp);
            }
        }
    }

    @Autowired
    @Generated
    public void setWarlockSecurityProp(WarlockSecurityProp warlockSecurityProp) {
        this.warlockSecurityProp = warlockSecurityProp;
    }

    @Autowired
    @Generated
    public void setWarlockJustAuthProp(WarlockJustAuthProp warlockJustAuthProp) {
        this.warlockJustAuthProp = warlockJustAuthProp;
    }

    @Autowired
    @Generated
    public void setSlardarSessionProp(SlardarSessionProp slardarSessionProp) {
        this.slardarSessionProp = slardarSessionProp;
    }
}

