/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.warlock.security.justauth.AuthStateBuilder;
import pro.fessional.wings.warlock.security.session.NonceTokenSessionHelper;

public class NonceLoginSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonceLoginSuccessHandler.class);
    protected AuthStateBuilder authStateBuilder;

    public final void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        State state = new State();
        long uid = SecurityContextUtil.getUserId();
        state.setUserId(uid);
        String sts = request.getParameter("state");
        state.setStateOauth(sts);
        HttpSession session = request.getSession(false);
        if (session != null) {
            String sid = session.getId();
            state.setSessionId(sid);
            if (sts != null) {
                NonceTokenSessionHelper.bindNonceSession(sts, sid);
                log.debug("parse oauth state={}, uid={}", (Object)sts, (Object)uid);
            }
        }
        state.setStateClient(this.authStateBuilder.parseState(request));
        this.onResponse(request, response, authentication, state);
    }

    protected void onResponse(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull Authentication aun, @NotNull State state) throws ServletException, IOException {
        super.onAuthenticationSuccess(req, res, aun);
    }

    @Autowired
    @Generated
    public void setAuthStateBuilder(AuthStateBuilder authStateBuilder) {
        this.authStateBuilder = authStateBuilder;
    }

    public static class State {
        private long userId;
        private String sessionId;
        private String stateOauth;
        private String stateClient;

        @Generated
        public State() {
        }

        @Generated
        public long getUserId() {
            return this.userId;
        }

        @Generated
        public String getSessionId() {
            return this.sessionId;
        }

        @Generated
        public String getStateOauth() {
            return this.stateOauth;
        }

        @Generated
        public String getStateClient() {
            return this.stateClient;
        }

        @Generated
        public void setUserId(long userId) {
            this.userId = userId;
        }

        @Generated
        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Generated
        public void setStateOauth(String stateOauth) {
            this.stateOauth = stateOauth;
        }

        @Generated
        public void setStateClient(String stateClient) {
            this.stateClient = stateClient;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserId() != other.getUserId()) {
                return false;
            }
            String this$sessionId = this.getSessionId();
            String other$sessionId = other.getSessionId();
            if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
                return false;
            }
            String this$stateOauth = this.getStateOauth();
            String other$stateOauth = other.getStateOauth();
            if (this$stateOauth == null ? other$stateOauth != null : !this$stateOauth.equals(other$stateOauth)) {
                return false;
            }
            String this$stateClient = this.getStateClient();
            String other$stateClient = other.getStateClient();
            return !(this$stateClient == null ? other$stateClient != null : !this$stateClient.equals(other$stateClient));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof State;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $userId = this.getUserId();
            result = result * 59 + (int)($userId >>> 32 ^ $userId);
            String $sessionId = this.getSessionId();
            result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
            String $stateOauth = this.getStateOauth();
            result = result * 59 + ($stateOauth == null ? 43 : $stateOauth.hashCode());
            String $stateClient = this.getStateClient();
            result = result * 59 + ($stateClient == null ? 43 : $stateClient.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "NonceLoginSuccessHandler.State(userId=" + this.getUserId() + ", sessionId=" + this.getSessionId() + ", stateOauth=" + this.getStateOauth() + ", stateClient=" + this.getStateClient() + ")";
        }
    }
}

