/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.session;

import org.cache2k.Cache;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;

public class NonceTokenSessionHelper {
    private static final Cache<String, Sf> cache = WingsCache2k.builder(NonceTokenSessionHelper.class, (String)"nonce", (int)100000, (int)300, (int)0, String.class, Sf.class).build();

    public static void initNonce(String token, String ip) {
        if (token == null || token.isEmpty()) {
            return;
        }
        Sf s = new Sf();
        s.ip = ip;
        cache.put((Object)token, (Object)s);
    }

    public static void bindNonceSession(String token, String sid) {
        if (token == null || token.isEmpty()) {
            return;
        }
        SidData data = () -> sid;
        R result = R.ok((Object)data);
        NonceTokenSessionHelper.bindNonceResult(token, result);
    }

    public static void bindNonceResult(String token, R<?> result) {
        if (token == null || token.isEmpty()) {
            return;
        }
        Sf s = (Sf)cache.get((Object)token);
        if (s != null) {
            s.result = result;
        }
    }

    public static void invalidNonce(String token) {
        if (token == null || token.isEmpty()) {
            return;
        }
        cache.remove((Object)token);
    }

    @Nullable
    public static R<?> authNonce(String token, String ip) {
        if (token == null || token.isEmpty()) {
            return null;
        }
        Sf s = (Sf)cache.get((Object)token);
        if (s == null) {
            return null;
        }
        if (s.result == null) {
            return R.NG();
        }
        NonceTokenSessionHelper.invalidNonce(token);
        return s.ip.equals(ip) ? s.result : null;
    }

    private static class Sf {
        private String ip = null;
        private R<?> result = null;

        private Sf() {
        }
    }

    public static interface SidData {
        public String getSid();
    }
}

