/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.userdetails;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.data.Null;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.pass.PasswordEncoders;
import pro.fessional.wings.warlock.enums.autogen.UserStatus;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService$Details$$$;
import pro.fessional.wings.warlock.service.auth.impl.DefaultUserDetailsCombo;

public class MemoryUserDetailsCombo
extends DefaultUserDetailsCombo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryUserDetailsCombo.class);
    private final Map<String, List<WarlockAuthnService.Details>> typedUser = new ConcurrentHashMap<String, List<WarlockAuthnService.Details>>();

    public void addUser(@NotNull WarlockAuthnService.Details dtl) {
        List set = this.typedUser.computeIfAbsent(dtl.getUsername(), k -> new CopyOnWriteArrayList());
        dtl.setPassword(PasswordEncoders.delegated((String)dtl.getPassword(), (String)"noop-md5"));
        log.info("add MemoryUser. uid={}, username={}, authType={}", new Object[]{dtl.getUserId(), dtl.getUsername(), dtl.getAuthType()});
        set.removeIf(it -> it.getAuthType() == dtl.getAuthType());
        set.add(dtl);
    }

    public void addUser(long userId, Enum<?> authType, @NotNull String username, @NotNull String password) {
        WarlockAuthnService.Details details = new WarlockAuthnService.Details();
        details.setUserId(userId);
        details.setAuthType(authType);
        details.setUsername(username);
        details.setPassword(password);
        details.setPasssalt("");
        details.setNickname(username);
        details.setStatus(UserStatus.ACTIVE);
        details.setExpiredDt(LocalDateTime.MAX);
        this.addUser(details);
    }

    public void delUser(@NotNull String username) {
        this.delUser(username, null);
    }

    public void delUser(@NotNull String username, Enum<?> authType) {
        if (authType == null) {
            this.delUser(username);
            return;
        }
        List<WarlockAuthnService.Details> set = this.typedUser.get(username);
        if (set != null) {
            set.removeIf(it -> it.getAuthType() == authType);
        }
    }

    @Override
    public WarlockAuthnService.Details doLoad(String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
        List<WarlockAuthnService.Details> details = this.typedUser.get(username);
        if (details == null || details.isEmpty()) {
            return null;
        }
        WarlockAuthnService.Details dtl = null;
        for (WarlockAuthnService.Details d : details) {
            if (d.getAuthType() == Null.Enm || authType == Null.Enm) {
                dtl = d;
                continue;
            }
            if (d.getAuthType() != authType) continue;
            dtl = d;
            break;
        }
        if (dtl == null) {
            return null;
        }
        if (dtl.getAuthType() == Null.Enm) {
            dtl = WarlockAuthnService$Details$$$.of(dtl);
            dtl.setAuthType(authType);
        } else {
            LocalDateTime now = Now.localDateTime();
            if (now.isAfter(dtl.getExpiredDt())) {
                details.removeIf(it -> now.isAfter(it.getExpiredDt()));
                dtl = null;
            }
        }
        return dtl;
    }
}

