/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.mirana.data.Null;
import pro.fessional.wings.slardar.security.impl.DefaultWingsUserDetails;
import pro.fessional.wings.warlock.service.auth.impl.ComboWarlockAuthzService;
import pro.fessional.wings.warlock.service.perm.WarlockPermNormalizer;

public class MemoryTypedAuthzCombo
implements ComboWarlockAuthzService.Combo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryTypedAuthzCombo.class);
    public static final int ORDER = -49999900;
    private int order = -49999900;
    protected WarlockPermNormalizer permNormalizer;
    private final Map<Long, Set<String>> userAuthz = new ConcurrentHashMap<Long, Set<String>>();
    private final Map<String, Set<String>> namedAuthz = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Map<Enum<?>, Set<String>>> typedAuthz = new ConcurrentHashMap();

    public void addAuthz(long userId, String ... authz) {
        this.addAuthz(userId, Arrays.asList(authz));
    }

    public void addAuthz(long userId, @NotNull Collection<String> authz) {
        Set set = this.userAuthz.computeIfAbsent(userId, k -> new CopyOnWriteArraySet());
        set.addAll(authz);
    }

    public void addAuthz(@NotNull String username, String ... authz) {
        this.addAuthz(username, Arrays.asList(authz));
    }

    public void addAuthz(@NotNull String username, @NotNull Collection<String> authz) {
        this.addAuthz(username, null, authz);
    }

    public void addAuthz(@NotNull String username, Enum<?> authType, String ... authz) {
        this.addAuthz(username, authType, Arrays.asList(authz));
    }

    public void addAuthz(@NotNull String username, Enum<?> authType, @NotNull Collection<String> authz) {
        if (authType == null || authType == Null.Enm) {
            Set set = this.namedAuthz.computeIfAbsent(username, k -> new CopyOnWriteArraySet());
            set.addAll(authz);
        } else {
            Map map = this.typedAuthz.computeIfAbsent(username, k -> new ConcurrentHashMap());
            Set set = map.computeIfAbsent(authType, k -> new CopyOnWriteArraySet());
            set.addAll(authz);
        }
    }

    public void delAuthz(long userId) {
        this.userAuthz.remove(userId);
    }

    public void delAuthz(long userId, @NotNull Collection<String> authz) {
        Set<String> set = this.userAuthz.get(userId);
        if (set != null) {
            set.removeAll(authz);
        }
    }

    public void delAuthz(@NotNull String username) {
        this.namedAuthz.remove(username);
    }

    public void delAuthz(@NotNull String username, @NotNull Collection<String> authz) {
        Set<String> set = this.namedAuthz.get(username);
        if (set != null) {
            set.removeAll(authz);
        }
    }

    public void delAuthz(@NotNull String username, Enum<?> authType) {
        if (authType == null) {
            this.delAuthz(username);
        } else {
            Map<Enum<?>, Set<String>> map = this.typedAuthz.get(username);
            if (map != null) {
                map.remove(authType);
            }
        }
    }

    public void delAuthz(@NotNull String username, Enum<?> authType, @NotNull Collection<String> authz) {
        if (authType == null) {
            this.delAuthz(username, authz);
        } else {
            Set<String> set;
            Map<Enum<?>, Set<String>> map = this.typedAuthz.get(username);
            if (map != null && (set = map.get(authType)) != null) {
                set.removeAll(authz);
            }
        }
    }

    @Override
    public boolean preAuth(@NotNull DefaultWingsUserDetails details, @NotNull HashSet<Object> role, @NotNull HashSet<Object> perm) {
        Enum at;
        Set<String> az2;
        Map<Enum<?>, Set<String>> map;
        Set<String> naz;
        Set<String> uaz = this.userAuthz.get(details.getUserId());
        if (uaz != null) {
            for (String string : uaz) {
                if (this.permNormalizer.indexRolePrefix(string) < 0) {
                    perm.add(string);
                    log.debug("add uid-perm={}", (Object)string);
                    continue;
                }
                role.add(string);
                log.debug("add uid-role={}", (Object)string);
            }
        }
        if ((naz = this.namedAuthz.get(details.getUsername())) != null) {
            for (String s : naz) {
                if (this.permNormalizer.indexRolePrefix(s) < 0) {
                    perm.add(s);
                    log.debug("add name-perm={}", (Object)s);
                    continue;
                }
                role.add(s);
                log.debug("add name-role={}", (Object)s);
            }
        }
        if ((map = this.typedAuthz.get(details.getUsername())) != null && (az2 = map.get(at = details.getAuthType())) != null) {
            for (String s : az2) {
                if (this.permNormalizer.indexRolePrefix(s) < 0) {
                    perm.add(s);
                    log.debug("add type-perm={}, type={}", (Object)s, (Object)at);
                    continue;
                }
                role.add(s);
                log.debug("add type-role={}, type={}", (Object)s, (Object)at);
            }
        }
        return false;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public WarlockPermNormalizer getPermNormalizer() {
        return this.permNormalizer;
    }

    @Generated
    public Map<Long, Set<String>> getUserAuthz() {
        return this.userAuthz;
    }

    @Generated
    public Map<String, Set<String>> getNamedAuthz() {
        return this.namedAuthz;
    }

    @Generated
    public Map<String, Map<Enum<?>, Set<String>>> getTypedAuthz() {
        return this.typedAuthz;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Autowired
    @Generated
    public void setPermNormalizer(WarlockPermNormalizer permNormalizer) {
        this.permNormalizer = permNormalizer;
    }
}

