/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.event.cache;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.wings.warlock.event.WarlockMetadataEvent;

public class TableChangeEvent
implements WarlockMetadataEvent {
    public static final int INSERT = 2;
    public static final int UPDATE = 4;
    public static final int DELETE = 8;
    private List<String> source = new LinkedList<String>();
    private int change = 0;
    private String table;
    private Map<String, List<?>> field = Collections.emptyMap();

    public boolean isInsert() {
        return (this.change & 2) != 0;
    }

    public boolean isUpdate() {
        return (this.change & 4) != 0;
    }

    public boolean isDelete() {
        return (this.change & 8) != 0;
    }

    public boolean hasChange(int mod) {
        return mod == 0 || (this.change & mod) != 0;
    }

    public void addSource(String src) {
        this.source.add(src);
    }

    public boolean hasSource(String src) {
        return this.source.contains(src);
    }

    public List<String> getSource() {
        return this.source;
    }

    public int getChange() {
        return this.change;
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, List<?>> getField() {
        return this.field;
    }

    public void setSource(List<String> source) {
        this.source = source;
    }

    public void setChange(int change) {
        this.change = change;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setField(Map<String, List<?>> field) {
        this.field = field;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableChangeEvent)) {
            return false;
        }
        TableChangeEvent other = (TableChangeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChange() != other.getChange()) {
            return false;
        }
        List<String> this$source = this.getSource();
        List<String> other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        Map<String, List<?>> this$field = this.getField();
        Map<String, List<?>> other$field = other.getField();
        return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof TableChangeEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChange();
        List<String> $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        Map<String, List<?>> $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        return result;
    }

    @NotNull
    public String toString() {
        return "TableChangeEvent(source=" + String.valueOf(this.getSource()) + ", change=" + this.getChange() + ", table=" + this.getTable() + ", field=" + String.valueOf(this.getField()) + ")";
    }
}

