/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.event.impl;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import pro.fessional.wings.warlock.event.cache.TableChangeEvent;
import pro.fessional.wings.warlock.service.event.TableChangePublisher;

public class TableChangePublisherImpl
implements TableChangePublisher {
    private static final Logger log = LoggerFactory.getLogger(TableChangePublisherImpl.class);
    private static final String EVENT_SRC = TableChangePublisherImpl.class.getName();
    private final ApplicationEventPublisher eventPublisher;

    @Override
    public void publish(@NotNull TableChangeEvent event) {
        if (event.hasSource(EVENT_SRC)) {
            log.debug("skip published event, table={}, change={}", (Object)event.getTable(), (Object)event.getChange());
        } else {
            log.debug("publish event={}", (Object)event);
            event.addSource(EVENT_SRC);
            this.eventPublisher.publishEvent((Object)event);
        }
    }

    public TableChangePublisherImpl(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

