/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.event.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.wings.faceless.database.WingsTableCudHandler;
import pro.fessional.wings.warlock.service.event.TableChangePublisher;

public class WingsTableCudHandlerImpl
implements WingsTableCudHandler {
    private static final Logger log = LoggerFactory.getLogger(WingsTableCudHandlerImpl.class);
    protected TableChangePublisher tableChangePublisher;
    protected final LinkedHashMap<Class<? extends WingsTableCudHandler.Auto>, WingsTableCudHandler.Auto> autoMap = new LinkedHashMap();

    public void register(@NotNull WingsTableCudHandler.Auto auto) {
        this.autoMap.put(auto.getClass(), auto);
    }

    public void handle(@NotNull Class<?> source, @NotNull WingsTableCudHandler.Cud cud, @NotNull String table, @NotNull Supplier<Map<String, List<?>>> field) {
        for (WingsTableCudHandler.Auto auto : this.autoMap.values()) {
            if (!auto.accept(source, cud, table)) continue;
            log.debug("skip auto handled, source={}, cud={}, table={}", new Object[]{source, cud, table});
            return;
        }
        Map<String, List<?>> fld = field.get();
        log.debug("handle, source={}, cud={}, table={}, field={}", new Object[]{source, cud, table, fld});
        if (cud == WingsTableCudHandler.Cud.Create) {
            this.tableChangePublisher.publishInsert(source, table, fld);
        } else if (cud == WingsTableCudHandler.Cud.Update) {
            this.tableChangePublisher.publishUpdate(source, table, fld);
        } else if (cud == WingsTableCudHandler.Cud.Delete) {
            this.tableChangePublisher.publishDelete(source, table, fld);
        } else {
            this.tableChangePublisher.publishAllCud(source, table, fld);
        }
    }

    @Autowired
    public void setTableChangePublisher(TableChangePublisher tableChangePublisher) {
        this.tableChangePublisher = tableChangePublisher;
    }

    public LinkedHashMap<Class<? extends WingsTableCudHandler.Auto>, WingsTableCudHandler.Auto> getAutoMap() {
        return this.autoMap;
    }
}

