/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.other;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import pro.fessional.mirana.text.JsonTemplate;
import pro.fessional.wings.faceless.database.manual.single.modify.commitjournal.CommitJournalModify;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.journal.impl.DefaultJournalService;
import pro.fessional.wings.faceless.service.lightid.BlockIdProvider;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.slardar.context.TerminalContext;

public class TerminalJournalService
extends DefaultJournalService {
    public TerminalJournalService(LightIdService ids, BlockIdProvider bid, CommitJournalModify mod) {
        super(ids, bid, mod);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @NotNull
    public <R> R submit(@NotNull String eventName, @Nullable String loginInfo, @Nullable String targetKey, @Nullable String otherInfo, @NotNull Function<JournalService.Journal, R> commitSet) {
        TerminalContext.Context ctx;
        if ((loginInfo == null || loginInfo.isEmpty()) && !(ctx = TerminalContext.get((boolean)false)).isNull()) {
            loginInfo = JsonTemplate.obj(obj -> {
                obj.putVal("userId", (Object)ctx.getUserId());
                obj.putVal("locale", (Object)ctx.getLocale().toLanguageTag());
                obj.putVal("zoneid", (Object)ctx.getZoneId().getId());
                obj.putVal("authType", (Object)ctx.getAuthType().name());
                obj.putVal("username", (Object)ctx.getUsername());
            });
        }
        return (R)super.submit(eventName, loginInfo, targetKey, otherInfo, commitSet);
    }
}

