/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.faceless.database.helper.DatabaseChecker;
import pro.fessional.wings.faceless.enums.LanguageEnumUtil;
import pro.fessional.wings.faceless.enums.StandardLanguageEnum;
import pro.fessional.wings.faceless.enums.StandardTimezoneEnum;
import pro.fessional.wings.faceless.enums.TimezoneEnumUtil;
import pro.fessional.wings.silencer.runner.ApplicationStartedEventRunner;
import pro.fessional.wings.silencer.runner.CommandLineRunnerOrdered;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.warlock.spring.prop.WarlockCheckProp;
import pro.fessional.wings.warlock.spring.prop.WarlockI18nProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class WarlockAutoRunConfiguration {
    private static final Log log = LogFactory.getLog(WarlockAutoRunConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public CommandLineRunnerOrdered databaseCheckerRunner(DataSource dataSource, WarlockCheckProp prop) {
        log.info((Object)"Warlock spring-runs databaseCheckerRunner");
        return new CommandLineRunnerOrdered(-70000000, ignored -> {
            DatabaseChecker.version((DataSource)dataSource);
            DatabaseChecker.timezone((DataSource)dataSource, (int)prop.getTzOffset(), (boolean)prop.isTzFail());
        });
    }

    @Bean
    @ConditionalWingsEnabled
    public ApplicationStartedEventRunner registerEnumUtilRunner(ObjectProvider<WarlockI18nProp> provider) {
        log.info((Object)"Warlock spring-runs registerEnumUtilRunner");
        return new ApplicationStartedEventRunner(-30000000, ignored -> {
            Class<?> cz;
            WarlockI18nProp warlockI18nProp = (WarlockI18nProp)provider.getIfAvailable();
            if (warlockI18nProp == null) {
                log.info((Object)"Warlock conf skip registerEnumUtil for NULL ");
                return;
            }
            for (String s : warlockI18nProp.getLocaleEnum()) {
                log.info((Object)("Warlock conf locale enum " + s));
                cz = Class.forName(s);
                if (!cz.isEnum() || !StandardLanguageEnum.class.isAssignableFrom(cz)) {
                    throw new IllegalArgumentException(s + " is not enum and StandardLanguageEnum");
                }
                for (Object o : cz.getEnumConstants()) {
                    LanguageEnumUtil.register((StandardLanguageEnum)((StandardLanguageEnum)o));
                }
            }
            for (String s : warlockI18nProp.getZoneidEnum()) {
                log.info((Object)("Warlock conf zoneid enum " + s));
                cz = Class.forName(s);
                if (!cz.isEnum() || !StandardTimezoneEnum.class.isAssignableFrom(cz)) {
                    throw new IllegalArgumentException(s + " is not enum and StandardTimezoneEnum");
                }
                for (Object o : cz.getEnumConstants()) {
                    TimezoneEnumUtil.register((StandardTimezoneEnum)((StandardTimezoneEnum)o));
                }
            }
        });
    }
}

