/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.conf;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import pro.fessional.mirana.cast.EnumConvertor;
import pro.fessional.wings.silencer.support.TypeSugar;

public interface RuntimeConfService {
    default public String getString(@NotNull String key) {
        return (String)this.getObject(key, TypeSugar.StringDescriptor);
    }

    default public String getString(@NotNull Class<?> key) {
        return this.getString(key.getName());
    }

    default public String getString(@NotNull Enum<?> key) {
        return this.getString(EnumConvertor.enum2Str(key));
    }

    default public int getInt(@NotNull String key, int els) {
        Integer obj = this.getSimple(key, Integer.class);
        return obj == null ? els : obj;
    }

    default public int getInt(@NotNull Class<?> key, int els) {
        return this.getInt(key.getName(), els);
    }

    default public int getInt(@NotNull Enum<?> key, int els) {
        return this.getInt(EnumConvertor.enum2Str(key), els);
    }

    default public boolean getBoolean(@NotNull String key, boolean els) {
        Boolean obj = this.getSimple(key, Boolean.class);
        return obj == null ? els : obj;
    }

    default public boolean getBoolean(@NotNull Class<?> key, boolean els) {
        return this.getBoolean(key.getName(), els);
    }

    default public boolean getBoolean(@NotNull Enum<?> key, boolean els) {
        return this.getBoolean(EnumConvertor.enum2Str(key), els);
    }

    default public long getLong(String key, long els) {
        Long obj = this.getSimple(key, Long.class);
        return obj == null ? els : obj;
    }

    default public long getLong(@NotNull Class<?> key, long els) {
        return this.getLong(key.getName(), els);
    }

    default public long getLong(@NotNull Enum<?> key, long els) {
        return this.getLong(EnumConvertor.enum2Str(key), els);
    }

    default public <T> T getSimple(@NotNull String key, @NotNull Class<T> type) {
        return this.getObject(key, TypeSugar.describe(type, (Class[])new Class[0]));
    }

    default public <T> T getSimple(@NotNull Class<?> key, @NotNull Class<T> type) {
        return this.getSimple(key.getName(), type);
    }

    default public <T> T getSimple(@NotNull Enum<?> key, @NotNull Class<T> type) {
        return this.getSimple(EnumConvertor.enum2Str(key), type);
    }

    default public <T extends Enum<T>> T getEnum(@NotNull Class<T> key) {
        return (T)((Enum)this.getSimple(key.getName(), key));
    }

    default public <T extends Enum<T>> List<T> getEnums(@NotNull Class<T> key) {
        return this.getList(key.getName(), key);
    }

    @NotNull
    default public <T> List<T> getList(@NotNull String key, @NotNull Class<T> type) {
        return (List)this.getObject(key, TypeSugar.describe(List.class, (Class[])new Class[]{type}));
    }

    @NotNull
    default public <T> List<T> getList(@NotNull Class<?> key, @NotNull Class<T> type) {
        return this.getList(key.getName(), type);
    }

    @NotNull
    default public <T> List<T> getList(@NotNull Enum<?> key, @NotNull Class<T> type) {
        return this.getList(EnumConvertor.enum2Str(key), type);
    }

    @NotNull
    default public <T> Set<T> getSet(@NotNull String key, @NotNull Class<T> type) {
        return (Set)this.getObject(key, TypeSugar.describe(Set.class, (Class[])new Class[]{type}));
    }

    @NotNull
    default public <T> Set<T> getSet(@NotNull Class<?> key, @NotNull Class<T> type) {
        return this.getSet(key.getName(), type);
    }

    @NotNull
    default public <T> Set<T> getSet(@NotNull Enum<?> key, @NotNull Class<T> type) {
        return this.getSet(EnumConvertor.enum2Str(key), type);
    }

    @NotNull
    default public <K, V> Map<K, V> getMap(@NotNull String key, @NotNull Class<K> keyType, @NotNull Class<V> valueType) {
        return (Map)this.getObject(key, TypeSugar.describe(Map.class, (Class[])new Class[]{keyType, valueType}));
    }

    @NotNull
    default public <K, V> Map<K, V> getMap(@NotNull Class<?> key, @NotNull Class<K> keyType, @NotNull Class<V> valueType) {
        return this.getMap(key.getName(), keyType, valueType);
    }

    @NotNull
    default public <K, V> Map<K, V> getMap(@NotNull Enum<?> key, @NotNull Class<K> keyType, @NotNull Class<V> valueType) {
        return this.getMap(EnumConvertor.enum2Str(key), keyType, valueType);
    }

    default public <T> T getObject(@NotNull Class<?> key, @NotNull TypeDescriptor type) {
        return this.getObject(key.getName(), type);
    }

    default public <T> T getObject(@NotNull Enum<?> key, @NotNull TypeDescriptor type) {
        return this.getObject(EnumConvertor.enum2Str(key), type);
    }

    public <T> T getObject(@NotNull String var1, @NotNull TypeDescriptor var2);

    public boolean setObject(@NotNull String var1, @NotNull Object var2);

    default public boolean setObject(@NotNull Class<?> key, @NotNull Object value) {
        return this.setObject(key.getName(), value);
    }

    default public boolean setObject(@NotNull Enum<?> key, @NotNull Object value) {
        return this.setObject(EnumConvertor.enum2Str(key), value);
    }

    public boolean newObject(@NotNull String var1, @NotNull Object var2, String var3, String var4, ResolvableType var5);

    default public boolean newObject(@NotNull Class<?> key, @NotNull Object value, String comment, String handler, ResolvableType outline) {
        return this.newObject(key.getName(), value, comment, handler, outline);
    }

    default public boolean newObject(@NotNull Enum<?> key, @NotNull Object value, String comment, String handler, ResolvableType outline) {
        return this.newObject(EnumConvertor.enum2Str(key), value, comment, handler, outline);
    }

    default public boolean newObject(@NotNull String key, @NotNull Object value, String comment, String handler, TypeDescriptor outline) {
        return this.newObject(key, value, comment, handler, outline == null ? (ResolvableType)null : outline.getResolvableType());
    }

    default public boolean newObject(@NotNull Class<?> key, @NotNull Object value, String comment, String handler, TypeDescriptor outline) {
        return this.newObject(key.getName(), value, comment, handler, outline == null ? (ResolvableType)null : outline.getResolvableType());
    }

    default public boolean newObject(@NotNull Enum<?> key, @NotNull Object value, String comment, String handler, TypeDescriptor outline) {
        return this.newObject(EnumConvertor.enum2Str(key), value, comment, handler, outline == null ? (ResolvableType)null : outline.getResolvableType());
    }

    default public boolean newObject(@NotNull String key, @NotNull Object value, String comment, String handler, Class<?> outline, Class<?> ... gernics) {
        return this.newObject(key, value, comment, handler, outline == null ? (ResolvableType)null : TypeSugar.resolve(outline, (Class[])gernics));
    }

    default public boolean newObject(@NotNull Class<?> key, @NotNull Object value, String comment, String handler, Class<?> outline, Class<?> ... gernics) {
        return this.newObject(key.getName(), value, comment, handler, outline == null ? (ResolvableType)null : TypeSugar.resolve(outline, (Class[])gernics));
    }

    default public boolean newObject(@NotNull Enum<?> key, @NotNull Object value, String comment, String handler, Class<?> outline, Class<?> ... gernics) {
        return this.newObject(EnumConvertor.enum2Str(key), value, comment, handler, outline == null ? (ResolvableType)null : TypeSugar.resolve(outline, (Class[])gernics));
    }

    default public boolean newObject(@NotNull String key, @NotNull Object value, String comment, String handler) {
        return this.newObject(key, value, comment, handler, (ResolvableType)null);
    }

    default public boolean newObject(@NotNull Class<?> key, @NotNull Object value, String comment, String handler) {
        return this.newObject(key.getName(), value, comment, handler, (ResolvableType)null);
    }

    default public boolean newObject(@NotNull Enum<?> key, @NotNull Object value, String comment, String handler) {
        return this.newObject(EnumConvertor.enum2Str(key), value, comment, handler, (ResolvableType)null);
    }

    default public boolean newObject(@NotNull String key, @NotNull Object value, String comment) {
        return this.newObject(key, value, comment, null, (ResolvableType)null);
    }

    default public boolean newObject(@NotNull Class<?> key, @NotNull Object value, String comment) {
        return this.newObject(key.getName(), value, comment, null, (ResolvableType)null);
    }

    default public boolean newObject(@NotNull Enum<?> key, @NotNull Object value, String comment) {
        return this.newObject(EnumConvertor.enum2Str(key), value, comment, null, (ResolvableType)null);
    }

    public boolean enable(@NotNull String var1, boolean var2);

    default public boolean enable(@NotNull Class<?> key, boolean enable) {
        return this.enable(key.getName(), enable);
    }

    default public boolean enable(@NotNull Enum<?> key, boolean enable) {
        return this.enable(EnumConvertor.enum2Str(key), enable);
    }
}

