/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.conf.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jooq.QueryPart;
import org.jooq.Record2;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.event.EventListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.wings.faceless.database.WingsTableCudHandler;
import pro.fessional.wings.silencer.enhance.ThisLazy;
import pro.fessional.wings.silencer.support.TypeSugar;
import pro.fessional.wings.warlock.caching.CacheConst;
import pro.fessional.wings.warlock.caching.CacheEventHelper;
import pro.fessional.wings.warlock.database.autogen.tables.WinConfRuntimeTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinConfRuntimeDao;
import pro.fessional.wings.warlock.database.autogen.tables.pojos.WinConfRuntime;
import pro.fessional.wings.warlock.event.cache.TableChangeEvent;
import pro.fessional.wings.warlock.service.conf.RuntimeConfService;

@CacheConfig(cacheNames={"service~RuntimeConfService!"}, cacheManager="MemoryCacheManager")
public class RuntimeConfServiceImpl
extends ThisLazy<RuntimeConfServiceImpl>
implements RuntimeConfService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuntimeConfServiceImpl.class);
    public static final String PropHandler = "prop";
    public static final String JsonHandler = "json";
    public static final String KryoHandler = "kryo";
    protected WinConfRuntimeDao winConfRuntimeDao;
    protected WingsTableCudHandler wingsTableCudHandler;
    private final Map<String, ConversionService> handlerMap = new LinkedHashMap<String, ConversionService>();

    public void putHandler(@NotNull String type, @NotNull ConversionService handler) {
        this.handlerMap.put(type, handler);
    }

    @Override
    public <T> T getObject(@NotNull String key, @NotNull TypeDescriptor type) {
        return ((RuntimeConfServiceImpl)this.thisLazy).getObjectCache(key, type);
    }

    @Override
    public boolean setObject(@NotNull String key, @NotNull Object value) {
        WinConfRuntimeTable t = (WinConfRuntimeTable)this.winConfRuntimeDao.getTable();
        String handler = (String)this.winConfRuntimeDao.fetchOne(String.class, (Table)t, t.Key.eq((Object)key), new QueryPart[]{t.Handler});
        ConversionService service = this.handlerMap.get(handler);
        String str = (String)service.convert(value, String.class);
        AssertArgs.notNull((Object)str, (String)"configKey", (String)"can not covert value to string, key={}", (Object[])new Object[]{key});
        int rc = this.winConfRuntimeDao.ctx().update((Table)t).set(t.Current, (Object)str).set(t.Previous, t.Current).where(t.Key.eq((Object)key)).execute();
        if (rc > 0) {
            this.wingsTableCudHandler.handle(this.getClass(), WingsTableCudHandler.Cud.Update, (Table)t, field -> {
                field.put(t.Key.getName(), List.of(key));
                field.put(t.Current.getName(), List.of(str));
            });
        }
        return rc >= 1;
    }

    @Override
    public boolean newObject(@NotNull String key, @NotNull Object value, String comment, String handler, ResolvableType structs) {
        AssertArgs.notEmpty((CharSequence)key, (String)"configKey", (String)"empty key");
        Class<?> valClaz = value.getClass();
        ConversionService service = null;
        if (handler == null) {
            for (Map.Entry<String, ConversionService> en : this.handlerMap.entrySet()) {
                if (!en.getValue().canConvert(valClaz, String.class)) continue;
                service = en.getValue();
                handler = en.getKey();
                break;
            }
        } else {
            ConversionService cs = this.handlerMap.get(handler);
            if (cs.canConvert(valClaz, String.class)) {
                service = cs;
            }
        }
        if (service == null) {
            return false;
        }
        String str = (String)service.convert(value, String.class);
        AssertArgs.notNull((Object)str, (String)"configKey", (String)"can not covert value to string, key={}", (Object[])new Object[]{key});
        if (structs == null) {
            structs = ResolvableType.forClass(valClaz);
        }
        WinConfRuntime pojo = new WinConfRuntime();
        pojo.setKey(key);
        pojo.setEnabled(true);
        pojo.setCurrent(str);
        pojo.setPrevious("");
        pojo.setInitial(str);
        pojo.setOutline(TypeSugar.outline((ResolvableType)structs));
        pojo.setComment(StringUtils.trimToEmpty((String)comment));
        pojo.setHandler(handler);
        int rc = this.winConfRuntimeDao.insertInto(pojo, false);
        log.info("newObject rc={}, key={}, han={}, val={}", new Object[]{rc, key, handler, str});
        if (rc > 0) {
            WingsTableCudHandler.Cud type = rc == 1 ? WingsTableCudHandler.Cud.Create : WingsTableCudHandler.Cud.Update;
            WinConfRuntimeTable t = (WinConfRuntimeTable)this.winConfRuntimeDao.getTable();
            this.wingsTableCudHandler.handle(this.getClass(), type, (Table)t, field -> {
                field.put(t.Key.getName(), List.of(key));
                field.put(t.Current.getName(), List.of(str));
            });
        }
        return rc >= 1;
    }

    @Override
    public boolean enable(@NotNull String key, boolean enable) {
        WinConfRuntimeTable t = (WinConfRuntimeTable)this.winConfRuntimeDao.getTable();
        int rc = this.winConfRuntimeDao.ctx().update((Table)t).set(t.Enabled, (Object)enable).where(t.Key.eq((Object)key)).execute();
        log.info("enable rc={}, key={}, enable={}", new Object[]{rc, key, enable});
        if (rc > 0) {
            this.wingsTableCudHandler.handle(this.getClass(), WingsTableCudHandler.Cud.Update, (Table)t, field -> {
                field.put(t.Key.getName(), List.of(key));
                field.put(t.Enabled.getName(), List.of(Boolean.valueOf(enable)));
            });
        }
        return rc >= 1;
    }

    @Cacheable
    public <T> T getObjectCache(@NotNull String key, @NotNull TypeDescriptor type) {
        if (this.winConfRuntimeDao.notTableExist()) {
            log.warn("winConfRuntimeDao.notTableExist, key={}", (Object)key);
            return null;
        }
        WinConfRuntimeTable t = (WinConfRuntimeTable)this.winConfRuntimeDao.getTable();
        Record2 r2 = (Record2)this.winConfRuntimeDao.ctx().select(t.Current, t.Handler).from((TableLike)t).where(t.Key.eq((Object)key)).and(t.Enabled.eq((Object)true)).fetchOne();
        if (r2 != null) {
            ConversionService service = this.handlerMap.get(r2.value2());
            Object obj = service.convert(r2.value1(), TypeSugar.StringDescriptor, type);
            return (T)obj;
        }
        return null;
    }

    @EventListener
    @CacheEvict(allEntries=true, condition="#result")
    public boolean evictAllConfCache(TableChangeEvent event) {
        String tb = CacheEventHelper.receiveTable(event, CacheConst.RuntimeConfService.EventTables, 12);
        if (tb != null) {
            log.debug("evictAllConfCache by {}, {}", (Object)tb, (Object)event);
            return true;
        }
        return false;
    }

    @Autowired
    @Generated
    public void setWinConfRuntimeDao(WinConfRuntimeDao winConfRuntimeDao) {
        this.winConfRuntimeDao = winConfRuntimeDao;
    }

    @Autowired
    @Generated
    public void setWingsTableCudHandler(WingsTableCudHandler wingsTableCudHandler) {
        this.wingsTableCudHandler = wingsTableCudHandler;
    }
}

