/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.wings.warlock.event.cache.TableChangeEvent;

public interface TableChangePublisher {
    default public void publishInsert(@NotNull Class<?> source, @NotNull String table, @NotNull Map<String, List<?>> field) {
        this.publish(2, source, table, field);
    }

    default public <R extends Record, F> void publishInsert(@NotNull Class<?> source, @NotNull TableField<R, F> field, @NotNull List<F> value) {
        this.publish(2, source, field, value);
    }

    default public <R extends Record> void publishInsert(@NotNull Class<?> source, @NotNull Table<R> table, @NotNull Map<TableField<R, ?>, List<?>> field) {
        this.publish(2, source, table, field);
    }

    default public void publishUpdate(@NotNull Class<?> source, @NotNull String table, @NotNull Map<String, List<?>> field) {
        this.publish(4, source, table, field);
    }

    default public <R extends Record, F> void publishUpdate(@NotNull Class<?> source, @NotNull TableField<R, F> field, @NotNull List<F> value) {
        this.publish(4, source, field, value);
    }

    default public <R extends Record> void publishUpdate(@NotNull Class<?> source, @NotNull Table<R> table, @NotNull Map<TableField<R, ?>, List<?>> field) {
        this.publish(4, source, table, field);
    }

    default public void publishDelete(@NotNull Class<?> source, @NotNull String table, @NotNull Map<String, List<?>> field) {
        this.publish(8, source, table, field);
    }

    default public <R extends Record, F> void publishDelete(@NotNull Class<?> source, @NotNull TableField<R, F> field, @NotNull List<F> value) {
        this.publish(8, source, field, value);
    }

    default public <R extends Record> void publishDelete(@NotNull Class<?> source, @NotNull Table<R> table, @NotNull Map<TableField<R, ?>, List<?>> field) {
        this.publish(8, source, table, field);
    }

    default public void publishAllCud(@NotNull Class<?> source, @NotNull String table, @NotNull Map<String, List<?>> field) {
        this.publish(14, source, table, field);
    }

    default public <R extends Record, F> void publishAllCud(@NotNull Class<?> source, @NotNull TableField<R, F> field, @NotNull List<F> value) {
        this.publish(14, source, field, value);
    }

    default public <R extends Record> void publishAllCud(@NotNull Class<?> source, @NotNull Table<R> table, @NotNull Map<TableField<R, ?>, List<?>> field) {
        this.publish(14, source, table, field);
    }

    default public <R extends Record, F> void publish(int cud, @NotNull Class<?> source, @NotNull TableField<R, F> field, @NotNull List<F> value) {
        Table table = field.getTable();
        AssertArgs.notNull((Object)table, (String)"tableField", (String)("field's table is null. field=" + String.valueOf(field)));
        this.publish(cud, source, table.getName(), Collections.singletonMap(field.getName(), value));
    }

    default public <R extends Record> void publish(int cud, @NotNull Class<?> source, @NotNull Table<R> table, @NotNull Map<TableField<R, ?>, List<?>> field) {
        HashMap map = new HashMap();
        for (Map.Entry<TableField<R, ?>, List<?>> en : field.entrySet()) {
            map.put(en.getKey().getName(), en.getValue());
        }
        this.publish(cud, source, table.getName(), map);
    }

    default public void publish(int cud, @NotNull Class<?> source, @NotNull String table, @NotNull Map<String, List<?>> field) {
        TableChangeEvent event = new TableChangeEvent();
        event.setChange(cud);
        event.addSource(source.getName());
        event.setTable(table);
        event.setField(field);
        this.publish(event);
    }

    public void publish(@NotNull TableChangeEvent var1);
}

