/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.grant;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PermGrantHelper {
    public static final String ALL = "*";
    public static final String SPL = ".";

    public static String unitePermit(String scopes, String action) {
        return scopes + SPL + action;
    }

    public static String[] splitPermit(String permit) {
        int p = permit.lastIndexOf(SPL);
        if (p > 0) {
            return new String[]{permit.substring(0, p), permit.substring(p + 1)};
        }
        if (p == 0) {
            return new String[]{"", permit.substring(1)};
        }
        return new String[]{"", permit};
    }

    public static boolean canInherit(String top, String sub) {
        return PermGrantHelper.canInherit(top, sub, SPL);
    }

    public static boolean canInherit(String top, String sub, String spl) {
        int t1;
        if (top == null || sub == null) {
            return false;
        }
        if (spl == null) {
            spl = SPL;
        }
        if ((t1 = top.lastIndexOf(spl)) < 0) {
            if (top.equals(ALL)) {
                return true;
            }
            return top.equalsIgnoreCase(sub);
        }
        int hl = t1 + 1;
        if (top.regionMatches(hl, ALL, 0, ALL.length())) {
            return t1 == 0 || sub.regionMatches(true, 0, top, 0, hl);
        }
        int s1 = sub.lastIndexOf(spl);
        if (s1 < 0) {
            return false;
        }
        return sub.regionMatches(true, 0, top, 0, hl) && sub.regionMatches(true, s1 + 1, top, hl, top.length() - hl);
    }

    @NotNull
    public static Set<String> inheritPerm(String permCode, Map<Long, String> permAll) {
        if (permAll == null || permCode == null) {
            return Collections.emptySet();
        }
        return permAll.values().stream().filter(it -> PermGrantHelper.canInherit(permCode, it)).collect(Collectors.toSet());
    }

    @NotNull
    public static Set<String> inheritPerm(long permId, Map<Long, String> permAll) {
        return PermGrantHelper.inheritPerm(permAll.get(permId), permAll);
    }

    @NotNull
    public static Set<String> grantRole(long roleId, Map<Long, String> roleAll, Map<Long, Set<Long>> roleGrant) {
        if (roleAll == null || roleGrant == null) {
            return Collections.emptySet();
        }
        HashMap<Long, String> out = new HashMap<Long, String>();
        PermGrantHelper.recur(roleId, out, roleAll, roleGrant);
        return new HashSet<String>(out.values());
    }

    private static void recur(Long rid, Map<Long, String> out, Map<Long, String> all, Map<Long, Set<Long>> map) {
        String rcd = all.get(rid);
        if (rcd == null) {
            return;
        }
        out.put(rid, rcd);
        Set sub = map.getOrDefault(rid, Collections.emptySet());
        for (Long id : sub) {
            if (out.containsKey(id)) continue;
            PermGrantHelper.recur(id, out, all, map);
        }
    }
}

