/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import pro.fessional.wings.silencer.modulate.ApiMode;
import pro.fessional.wings.silencer.modulate.RunMode;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.runner.CommandLineRunnerOrdered;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.serialize.JsonConversion;
import pro.fessional.wings.slardar.serialize.KryoConversion;
import pro.fessional.wings.warlock.database.WarlockDatabase;
import pro.fessional.wings.warlock.service.conf.RuntimeConfService;
import pro.fessional.wings.warlock.service.conf.impl.RuntimeConfServiceImpl;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class WarlockAwesomeConfiguration {
    private static final Log log = LogFactory.getLog(WarlockAwesomeConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public CommandLineRunnerOrdered registerRuntimeModeRunner(ObjectProvider<RuntimeConfService> provider) {
        log.info((Object)"Warlock spring-runs registerRuntimeModeRunner");
        return new CommandLineRunnerOrdered(-50000000, ignored -> {
            RuntimeConfService confService = (RuntimeConfService)provider.getIfAvailable();
            if (confService == null) {
                log.info((Object)"Warlock conf skip registerRuntimeMode for NULL ");
                return;
            }
            RunMode dbRunMode = confService.getEnum(RunMode.class);
            ApiMode dbApiMode = confService.getEnum(ApiMode.class);
            log.info((Object)("Warlock conf RuntimeMode, runMode=" + String.valueOf(dbRunMode) + ", apiMode=" + String.valueOf(dbApiMode)));
            new RuntimeMode(this, dbRunMode, dbApiMode){};
        });
    }

    @Bean
    @ConditionalWingsEnabled
    public RuntimeConfService runtimeConfService(ObjectProvider<ConversionService> conversionProvider) {
        log.info((Object)"Warlock spring-bean runtimeConfService");
        RuntimeConfServiceImpl bean = new RuntimeConfServiceImpl();
        conversionProvider.ifAvailable(it -> bean.putHandler("prop", (ConversionService)it));
        bean.putHandler("json", (ConversionService)new JsonConversion());
        bean.putHandler("kryo", (ConversionService)new KryoConversion());
        return bean;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    @ComponentScan(basePackageClasses={WarlockDatabase.class})
    public static class JooqDaoScan {
        public JooqDaoScan() {
            log.info((Object)"Warlock spring-scan SysConstantEnumDao");
        }
    }
}

