/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.ExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.faceless.database.jooq.listener.SlowSqlListener;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.watch.WatchingAround;
import pro.fessional.wings.warlock.spring.prop.WarlockWatchingProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.warlock.watching", value=false)
public class WarlockWatchingConfiguration {
    private static final Log log = LogFactory.getLog(WarlockWatchingConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnExpression(value="${wings.warlock.watching.jooq-threshold:-1} >=0")
    public DefaultExecuteListenerProvider slowSqlJooqListener(WarlockWatchingProp prop) {
        long ms = prop.getJooqThreshold();
        log.info((Object)("Warlock spring-bean slowSqlJooqListener, threshold=" + ms));
        SlowSqlListener bean = new SlowSqlListener();
        bean.setThresholdMillis(ms);
        return new DefaultExecuteListenerProvider((ExecuteListener)bean);
    }

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnExpression(value="${wings.warlock.watching.service-threshold:-1} >=0")
    public WatchingAround watchingAround(WarlockWatchingProp prop) {
        long ms = prop.getServiceThreshold();
        log.info((Object)("Warlock spring-bean watchingAround, threshold=" + ms));
        WatchingAround bean = new WatchingAround();
        bean.setThresholdMillis(ms);
        return bean;
    }
}

