/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import javax.swing.JOptionPane;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.StdJavaRuntimeProvider;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.modules.LauncherInitContext;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaRuntimeModule
extends LauncherModule {
    public static final String RUNTIME_NAME = "stdruntime";
    static LauncherEngine engine;
    private RuntimeProvider provider;

    public JavaRuntimeModule() {
        super(new LauncherModuleInfo("StdJavaRuntime", new Version(1, 3, 0, 1, Version.Type.STABLE), 0, new String[0], new String[]{"runtime"}));
    }

    private static void noJavaFxAlert() {
        String message = String.format("\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 JavaFX \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b. \u0423 \u0432\u0430\u0441 %s(x%d) \u041e\u0421 %s(x%d). Java %s. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 JavaFX, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 OracleJRE 8 x%d \u0441 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430.\n\u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443 \u0441\u0430\u043c\u043e\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u043d\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0432\u043e\u0435\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430", JVMHelper.RUNTIME_MXBEAN.getVmName(), JVMHelper.JVM_BITS, JVMHelper.OS_TYPE.name, JVMHelper.OS_BITS, JVMHelper.RUNTIME_MXBEAN.getSpecVersion(), JVMHelper.OS_BITS);
        JOptionPane.showMessageDialog(null, message, "GravitLauncher", 0);
    }

    public void init(LauncherInitContext initContext) {
        this.registerEvent(this::preGuiPhase, ClientPreGuiPhase.class);
        this.registerEvent(this::engineInitPhase, ClientEngineInitPhase.class);
        this.registerEvent(this::exitPhase, ClientExitPhase.class);
    }

    private void preGuiPhase(ClientPreGuiPhase phase) {
        try {
            Class.forName("javafx.application.Application");
        }
        catch (ClassNotFoundException e) {
            JavaRuntimeModule.noJavaFxAlert();
            LauncherEngine.exitLauncher((int)0);
        }
        phase.runtimeProvider = this.provider = new StdJavaRuntimeProvider();
    }

    private void engineInitPhase(ClientEngineInitPhase initPhase) {
        engine = initPhase.engine;
    }

    private void exitPhase(ClientExitPhase exitPhase) {
        if (this.provider != null && this.provider instanceof StdJavaRuntimeProvider) {
            try {
                ((StdJavaRuntimeProvider)this.provider).getApplication().saveSettings();
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
    }
}

