/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.JavaRuntimeModule;
import pro.gravit.launcher.client.StdJavaRuntimeProvider;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launcher.request.secure.VerifySecureLevelKeyRequest;
import pro.gravit.launcher.utils.HWIDProvider;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class RuntimeSecurityService {
    private static final Path BINARY_PATH = IOHelper.getCodeSource(Launcher.class);
    private static final Path C_BINARY_PATH = BINARY_PATH.resolveSibling(IOHelper.getFileName((Path)BINARY_PATH) + ".tmp");
    private final JavaFXApplication application;
    private final Boolean[] waitObject = new Boolean[]{null};

    public RuntimeSecurityService(JavaFXApplication application) {
        this.application = application;
    }

    public void startRequest() throws IOException {
        ((CompletableFuture)this.application.service.request((Request)new GetSecureLevelInfoRequest()).thenAccept(event -> {
            if (!event.enabled || event.verifySecureKey == null) {
                LogHelper.info((String)"Advanced security level disabled");
                this.notifyWaitObject(false);
                return;
            }
            byte[] signature = this.sign(event.verifySecureKey);
            try {
                ((CompletableFuture)this.application.service.request((Request)new VerifySecureLevelKeyRequest(JavaRuntimeModule.engine.publicKey.getEncoded(), signature)).thenAccept(event1 -> {
                    if (!event1.needHardwareInfo) {
                        LogHelper.info((String)"Advanced security level success completed");
                        this.notifyWaitObject(true);
                    } else {
                        this.doCollectHardwareInfo(!event1.onlyStatisticInfo);
                    }
                })).exceptionally(e -> {
                    this.application.messageManager.createNotification("Hardware Checker", e.getCause().getMessage());
                    this.notifyWaitObject(false);
                    return null;
                });
            }
            catch (IOException e2) {
                LogHelper.error((String)"VerifySecureLevel failed: %s", (Object[])new Object[]{e2.getMessage()});
                this.notifyWaitObject(false);
            }
        })).exceptionally(e -> {
            LogHelper.info((String)"Advanced security level disabled(exception)");
            this.notifyWaitObject(false);
            return null;
        });
    }

    private void doCollectHardwareInfo(boolean needSerial) {
        CommonHelper.newThread((String)"HardwareInfo Collector Thread", (boolean)true, () -> {
            HWIDProvider provider = new HWIDProvider();
            HardwareReportRequest.HardwareInfo info = provider.getHardwareInfo(needSerial);
            HardwareReportRequest reportRequest = new HardwareReportRequest();
            reportRequest.hardware = info;
            try {
                ((CompletableFuture)this.application.service.request((Request)reportRequest).thenAccept(event -> {
                    LogHelper.info((String)"Advanced security level success completed");
                    this.notifyWaitObject(true);
                })).exceptionally(exc -> {
                    this.application.messageManager.createNotification("Hardware Checker", exc.getCause().getMessage());
                    return null;
                });
            }
            catch (IOException e) {
                LogHelper.error((Throwable)e);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitObject(boolean state) {
        Boolean[] booleanArray = this.waitObject;
        synchronized (this.waitObject) {
            this.waitObject[0] = state;
            this.waitObject.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSecurityState() throws InterruptedException {
        Boolean[] booleanArray = this.waitObject;
        synchronized (this.waitObject) {
            if (this.waitObject[0] == null) {
                this.waitObject.wait(3000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.waitObject[0];
        }
    }

    public void update(LauncherRequestEvent result) throws IOException {
        ArrayList<String> args = new ArrayList<String>(8);
        args.add(IOHelper.resolveJavaBin(null).toString());
        if (LogHelper.isDebugEnabled()) {
            args.add(JVMHelper.jvmProperty((String)"launcher.debug", (String)Boolean.toString(LogHelper.isDebugEnabled())));
        }
        args.add("-jar");
        args.add(BINARY_PATH.toString());
        ProcessBuilder builder = new ProcessBuilder(args.toArray(new String[0]));
        builder.inheritIO();
        try {
            LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(0));
            Request.service.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Files.deleteIfExists(C_BINARY_PATH);
        if (result.binary != null) {
            IOHelper.write((Path)C_BINARY_PATH, (byte[])result.binary);
        } else {
            URL url;
            try {
                url = new URL(result.url);
            }
            catch (MalformedURLException e) {
                throw new IOException(e);
            }
            URLConnection connection = url.openConnection();
            try (InputStream in = connection.getInputStream();){
                IOHelper.transfer((InputStream)in, (Path)C_BINARY_PATH);
            }
        }
        if (Arrays.equals(SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)C_BINARY_PATH), SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)BINARY_PATH))) {
            throw new IOException("Invalid update (launcher needs update, but link has old launcher), check LaunchServer config...");
        }
        StdJavaRuntimeProvider.launcherUpdateTempPath = C_BINARY_PATH;
        StdJavaRuntimeProvider.processBuilder = builder;
    }

    public byte[] sign(byte[] data) {
        return SecurityHelper.sign((byte[])data, (ECPrivateKey)JavaRuntimeModule.engine.privateKey);
    }

    public boolean isMayBeDownloadJava() {
        return JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE;
    }
}

