/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class StdJavaRuntimeProvider
implements RuntimeProvider {
    public static Path launcherUpdateTempPath;
    public static ProcessBuilder processBuilder;
    private static final AtomicReference<StdJavaRuntimeProvider> INSTANCE;

    public StdJavaRuntimeProvider() {
        INSTANCE.set(this);
    }

    public static StdJavaRuntimeProvider getInstance() {
        return INSTANCE.get();
    }

    public JavaFXApplication getApplication() {
        return JavaFXApplication.getInstance();
    }

    public void run(String[] args) {
        Application.launch(JavaFXApplication.class, (String[])args);
        LogHelper.debug((String)"Post Application.launch method invoked");
        if (launcherUpdateTempPath != null && processBuilder != null) {
            try {
                Path BINARY_PATH = IOHelper.getCodeSource(Launcher.class);
                try (InputStream in = IOHelper.newInput((Path)launcherUpdateTempPath);){
                    IOHelper.transfer((InputStream)in, (Path)BINARY_PATH);
                }
                Files.deleteIfExists(launcherUpdateTempPath);
                processBuilder.start();
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
        System.exit(0);
    }

    public void preLoad() {
    }

    public void init(boolean clientInstance) {
    }

    static {
        INSTANCE = new AtomicReference();
    }
}

