/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import javafx.fxml.FXMLLoader;
import pro.gravit.utils.helper.LogHelper;

public class FXMLProvider {
    private final Function<String, FXMLLoader> loaderFactory;
    private final ExecutorService executorService;
    private final Map<String, Object> fxmlCache = new ConcurrentHashMap<String, Object>();

    public FXMLProvider(Function<String, FXMLLoader> loaderFactory, ExecutorService executorService) {
        this.loaderFactory = loaderFactory;
        this.executorService = executorService;
    }

    public <T> Future<T> queue(String name, InputStream inputStream) {
        LogHelper.dev((String)"FXML queue %s", (Object[])new Object[]{name});
        this.fxmlCache.put(name, new FutureVirtualObject());
        return this.executorService.submit(() -> {
            try {
                long start = System.currentTimeMillis();
                Object result = this.rawLoadFxml(name, inputStream);
                Object cacheEntry = this.fxmlCache.get(name);
                this.fxmlCache.put(name, result);
                if (cacheEntry instanceof FutureVirtualObject) {
                    Object object = cacheEntry;
                    synchronized (object) {
                        cacheEntry.notifyAll();
                    }
                }
                long finish = System.currentTimeMillis();
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.debug((String)"FXML %s(%s) loaded in %d ms", (Object[])new Object[]{name, result.getClass().getName(), finish - start});
                }
                return result;
            }
            catch (Throwable e) {
                Object cacheEntry = this.fxmlCache.get(name);
                if (cacheEntry instanceof FutureVirtualObject) {
                    Object object = cacheEntry;
                    synchronized (object) {
                        ((FutureVirtualObject)cacheEntry).exception = e instanceof IOException ? (IOException)e : new IOException(e);
                        cacheEntry.notifyAll();
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getFxml(String name) throws InterruptedException, IOException {
        Object cacheEntry = this.fxmlCache.get(name);
        if (cacheEntry == null) {
            throw new IllegalStateException(String.format("You must need queue fxml load %s", name));
        }
        if (cacheEntry instanceof FutureVirtualObject) {
            if (((FutureVirtualObject)cacheEntry).exception != null) {
                throw ((FutureVirtualObject)cacheEntry).exception;
            }
            Object object = cacheEntry;
            synchronized (object) {
                cacheEntry.wait();
            }
            cacheEntry = this.fxmlCache.get(name);
            if (cacheEntry instanceof FutureVirtualObject && ((FutureVirtualObject)cacheEntry).exception != null) {
                throw ((FutureVirtualObject)cacheEntry).exception;
            }
        }
        return (T)cacheEntry;
    }

    private <T> T rawLoadFxml(String name, InputStream inputStream) throws IOException {
        Object result = this.loaderFactory.apply(name).load(inputStream);
        inputStream.close();
        return (T)result;
    }

    public <T> Future<T> queueNoCache(String name, InputStream inputStream) {
        this.fxmlCache.put(name, new FutureVirtualObject());
        return this.executorService.submit(() -> {
            try {
                long start = System.currentTimeMillis();
                Object result = this.rawLoadFxml(name, inputStream);
                long finish = System.currentTimeMillis();
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.debug((String)"FXML %s(%s) loaded in %d ms(no cache)", (Object[])new Object[]{name, result.getClass().getName(), finish - start});
                }
                return result;
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
                return null;
            }
        });
    }

    private static class FutureVirtualObject {
        public IOException exception;

        private FutureVirtualObject() {
        }
    }
}

