/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui;

import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.raw.ContextHelper;
import pro.gravit.launcher.client.gui.scene.LoginScene;
import pro.gravit.launcher.events.NotificationEvent;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.ClientWebSocketService;
import pro.gravit.utils.helper.LogHelper;

public class GuiEventHandler
implements ClientWebSocketService.EventHandler {
    private final JavaFXApplication application;

    public GuiEventHandler(JavaFXApplication application) {
        this.application = application;
    }

    public <T extends WebSocketEvent> boolean eventHandle(T event) {
        LogHelper.dev((String)"Processing event %s", (Object[])new Object[]{event.getType()});
        if (event instanceof RequestEvent && !((RequestEvent)event).requestUUID.equals(RequestEvent.eventUUID)) {
            return false;
        }
        try {
            if (event instanceof NotificationEvent) {
                NotificationEvent e = (NotificationEvent)event;
                ContextHelper.runInFxThreadStatic(() -> this.application.messageManager.createNotification(e.head, e.message));
            } else if (event instanceof AuthRequestEvent) {
                boolean isNextScene = this.application.getCurrentScene() instanceof LoginScene;
                LogHelper.dev((String)"Receive auth event. Send next scene %s", (Object[])new Object[]{isNextScene ? "true" : "false"});
                this.application.runtimeStateMachine.setAuthResult((AuthRequestEvent)event);
                if (isNextScene && ((LoginScene)this.application.getCurrentScene()).isLoginStarted) {
                    ((LoginScene)this.application.getCurrentScene()).onGetProfiles();
                }
            }
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
        }
        return false;
    }
}

